package com.yizhi.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 答卷
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */

@Data
@TableName("tr_exam_answer")
public class TrExamAnswer extends Model<TrExamAnswer> {

    private static final long serialVersionUID = 1L;

    
    private Long id;

    
    @TableField("exam_id")
    private Long examId;

    
    @TableField("account_id")
    private Long accountId;

    
    @TableField("start_time")
    private Date startTime;

    
    @TableField("submit_time")
    private Date submitTime;

    
    private Integer duration;

    
    @TableField("terminal_type")
    private Integer terminalType;

    
    private BigDecimal score;

    
    @TableField("state")
    private Integer state;

    
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    
    @TableField(value = "create_by_id", fill = FieldFill.INSERT)
    private Long createById;

    
    @TableField(value = "create_by_name", fill = FieldFill.INSERT)
    private String createByName;

    
    @TableField(value = "update_time", fill = FieldFill.INSERT)
    private Date updateTime;

    
    @TableField(value = "update_by_id", fill = FieldFill.INSERT)
    private Long updateById;

    
    @TableField(value = "update_by_name", fill = FieldFill.INSERT)
    private String updateByName;

    
    @TableField("company_id")
    private Long companyId;

    
    @TableField("org_id")
    private Long orgId;

    
    @TableField("site_id")
    private Long siteId;

    
    @TableField(value = "training_project_id")
    private Long trainingProjectId;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

}
