package com.yizhi.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 答案题目
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */

@Data
@TableName("tr_exam_answer_question")
public class TrExamAnswerQuestion extends Model<TrExamAnswerQuestion> {

	private static final long serialVersionUID = 1L;

	
	private Long id;

	
	@TableField("answer_id")
	private Long answerId;

	
	@TableField("exam_question_id")
	private Long examQuestionId;

	
	@TableField("library_id")
	private Long libraryId;

	
	@TableField("subject_id")
	private Long subjectId;

	
	@TableField("account_id")
	private Long accountId;

	
	private BigDecimal score;

	
	private Integer mark;

	
	@TableField(value = "create_time", fill = FieldFill.INSERT)
	private Date createTime;

	
	@TableField(value = "create_by_id", fill = FieldFill.INSERT)
	private Long createById;

	
	@TableField(value = "create_by_name", fill = FieldFill.INSERT)
	private String createByName;

	
	@TableField(value = "update_time", fill = FieldFill.INSERT)
	private Date updateTime;

	
	@TableField(value = "update_by_id", fill = FieldFill.INSERT)
	private Long updateById;

	
	@TableField(value = "update_by_name", fill = FieldFill.INSERT)
	private String updateByName;

	
	private Long sort;
	
	@Override
	protected Serializable pkVal() {
		return this.id;
	}
}
