package com.yizhi.application.mapper;

import com.yizhi.exam.application.vo.exam.*;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 考生考试试卷生成Mapper
 * @author mei
 *
 */
public interface ExamPaperMapper {
	
	/**
	 * 获取企业的考试信息
	 * @param examId 考试ID，必输
	 * @param companyId 企业ID，必输
	 * @param orgId 部门ID，可为空
	 * @param siteId 站点ID，可为空
	 * @return 成功返回试卷试题，失败返回null
	 */
	ExamPaperVO selectExam(@Param("examId")Long examId, @Param("companyId")Long companyId, 
			@Param("orgId")Long orgId, @Param("siteId")Long siteId);
	
	/**
	 * 获取考试的题型排序策略
	 * @param examId 考试ID，必输
	 * @return 成功返回题型排序策略集合，失败返回null
	 */
	List<ExamQuestionSortVO> selectExamQuestionSorts(@Param("examId")Long examId);
	
	/**
	 * 获取考试的系统出题规则
	 * @param examId考试ID，必输
	 * @return 成功返回系统出题规则集合，失败返回null
	 */
	List<QuestionOptionSystemListVO> selectQuestionOptionSystemList(@Param("examId")Long examId);
	
	/**
	 * 获取必答考题的所有考题和选项，按默认排序。废弃不用了，按题干排序（stemSort为null、1、3默认排序，为2题型排序）
	 * @param examId 考试ID，必输
	 * @param stemSort 废弃不用了，题干排序，null、1、3默认排序，2题型排序
	 * @return 成功返回考题策略集合，失败返回null
	 */
	List<QuestionListVO> selectQuestionList(@Param("examId")Long examId, @Param("stemSort")Integer stemSort);
	
	/**
	 * 获取考题选项
	 * @param subjectId 题目ID，必输
	 * @param companyId 企业ID，必输
	 * @param orgId 部门ID，可为空
	 * @param siteId 站点ID，可为空
	 * @return 成功返回题选项集合，失败返回null
	 */
	List<QuestionOptionListVO> selectQuestionOptionList(@Param("subjectId")Long subjectId);
	
	/**
	 * 获取题库的所有考题，过滤已在必答题中出现的题目。系统出题中不能像必答题一样设置题干的排序，则按题干名称排序
	 * @param examId 考试ID，必输
	 * @param libraryId 题库ID，必输
	 * @param type 题型排序
	 * @return成功返回题目集合，失败返回null
	 */
	List<QuestionListVO> selectLibraryQuestionList(@Param("examId")Long examId, 
			@Param("libraryId")Long libraryId, @Param("type")Integer type, @Param("makeStrategy")Integer makeStrategy);
	
	/** del
	 * 获取系统出题规则和考试的考题所有试题和选项，按题干排序（stemSort为null、1、3默认排序，为2题型排序）
	 * @param examId 考试ID，必输
	 * @param stemSort 题干排序，null、1、3默认排序，2题型排序
	 * @return 成功返回考题策略集合，失败返回null
	 */
	List<QuestionListVO> selectLibraryAndQuestionList(@Param("examId")Long examId, @Param("stemSort")Integer stemSort);
}
