package com.yizhi.application.mapper;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.yizhi.application.domain.TrExamAnswerQuestionResMa;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

/**
 * <p>
 * 主观题答案选项 Mapper 接口
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
public interface TrExamAnswerQuestionResMaMapper extends BaseMapper<TrExamAnswerQuestionResMa> {

    @Select("select answer from tr_exam_answer_question_res_ma where answer_question_id = #{id} and answer_id = #{answerId}")
    String selectAnswer(@Param("id") Long id,@Param("answerId") Long answerId);
    
    /**
	 * 查询主观题选项
	 * @param answerId
	 * @param questionId
	 * @return
	 */
    @Select("SELECT * FROM tr_exam_answer_question_res_ma "
    		+ "WHERE answer_question_id = #{questionId} and answer_id = #{answerId}")
    TrExamAnswerQuestionResMa selectAnswerQuestionOptionByAnswerIdAndQuestionId(@Param("answerId") Long answerId, 
    		@Param("questionId")Long questionId);
}
