package com.yizhi.application.service;

import com.yizhi.exam.application.vo.exam.ExamPaperVO;
import com.yizhi.exam.application.vo.exam.StudentExamPaperVO;

import java.util.Date;

/**
 * 试卷
 * @author mei
 *
 */
public interface IStudentExamPaperService {
	
	/**
	 * 创建考试题目，放入缓存中
	 * @param examId 考试ID
	 * @param companyId 企业ID
	 * @param orgId 组织ID
	 * @param siteId 站点 ID
	 * @param time 考试失效时间（秒）
	 * @return 返回考试试题
	 */
	ExamPaperVO makeExamQuestion(Long examId, Long companyId, Long orgId, Long siteId, Long time);
	
	/**
	 * 创建考生试卷，放入缓存中
	 * @param accountId 考生ID
	 * @param examId 考试ID
	 * @param time 考试失效时间（秒）
	 * @param createTime 生成答卷的时间
	 * @return 返回考生试卷
	 */
	public StudentExamPaperVO makeStudentExam(ExamPaperVO examPaperVO, Long accountId, Long examId, Long time, Date createTime);
	
	/**
	 * 检查考生是否参加了考试
	 * @param accountId 考生ID
	 * @param examId 考试ID
	 * @return
	 */
	public Long isExists(Long accountId, Long examId);
	
	/**
	 * 清空考试缓存
	 * @param accountId 考生ID
	 * @param examId 考试ID
	 * @return
	 */
	public void clearExam(Long examId);
	
	/**
	 * 清空考生试卷缓存
	 * @param accountId 考生ID
	 * @param examId 考试ID
	 * @return
	 */
	public void clearStudentExam(Long accountId, Long examId);
	
	public void updateExamAnswerState(Long answerId);
	
	/**
	 * 获取考生试卷（从缓存中获取，获取不到查询数据库）
	 * @param accountId 考生ID
	 * @param examId 考试ID
	 * @param time 考试失效时间（秒）
	 * @param createTime 生成答卷的时间
	 * @return 返回考生试卷
	 */
	public StudentExamPaperVO getMakeStudentExam(Long accountId, Long examId, Long answerId, Long time);
}
