package com.yizhi.application.service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.IService;
import com.yizhi.application.domain.TrExamAnswer;
import com.yizhi.exam.application.vo.AnswerDetailVO;
import com.yizhi.exam.application.vo.AnswerQuestionDetailVO;
import com.yizhi.exam.application.vo.AnswerQuestionListVO;
import com.yizhi.exam.application.vo.ExamAnswerByUserVO;
import com.yizhi.exam.application.vo.ExamAnswerVO;
import com.yizhi.exam.application.vo.dashboard.ExamDashboardQueryVO;
import com.yizhi.exam.application.vo.exam.AnswerTimeVO;
import com.yizhi.exam.application.vo.exam.ExamHistoryVO;
import com.yizhi.exam.application.vo.exam.StatisticalCountVO;

/**
 * <p>
 * 答卷 服务类
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
public interface ITrExamAnswerService extends IService<TrExamAnswer> {


    Page<TrExamAnswer> getExamAnswerByExamId(Long examId, Integer pageNo, Integer pageSize, Long accountId, Long orgId);


    /**
     * 已经提交试卷的人数
     *
     * @param examId
     * @return
     */
    Integer getCommitNum(Long examId);


    /**
     * 查看没有考试的人员id
     *
     * @param examId
     * @return
     */
    List<Long> noExamIdList(Long examId, List<Long> shouldListId);


    /**
     * 根据考试ID和学员ID查看最后一次答卷的内容
     */
    TrExamAnswer selectLastAnswer(Long examId, Long accountId);


    /**
     * 获得考试详情
     *
     * @return
     */
    List<ExamAnswerVO> selectExamAnswerByExamId(List<Long> accountIdList, List<Long> orgIdList, Integer state,
                                                String start, String end, Long examId, Integer pageNo, Integer pageSize);

    /**
     * 获得考试调教作业的个数
     */
    Integer selectTotal(List<Long> accountIdList, List<Long> orgIdList, Integer state,
                        String start, String end, Long examId);

    /**
     * 学员端查看考试结果列表
     *
     * @param examId
     * @param accountId
     * @return
     */
    List<TrExamAnswer> getExamAnswerListByExamIdAndAccountId(Long examId, Long accountId);


    List<ExamAnswerVO> getExamAnswer(Long examId);

    /**
     * 获取考试历史数据(已提交和阅卷)
     *
     * @param aId
     * @return
     */
    List<ExamHistoryVO> selectExamHisList(Long accountId, Long examId);

    Integer selectMaxScore(Long accountId);

    /**
     * 答卷页面
     *
     * @param answerId
     * @return
     */

    AnswerDetailVO answerDetail(Long accountId, Integer time, Integer pageNo, Integer pageSize, Long examId);

    Page<AnswerQuestionDetailVO> answerQuestionDetail(Long answerId, int pageNo, int pageSize);

    /**
     * 获取考试开始时间和答卷时长
     */
    AnswerTimeVO selectTime(Long examId, Long answerId);


    /**
     * 根据examId和AccountID获取考试历史
     */
    List<ExamHistoryVO> selectHistorys(Long examId, Long accountId);

    /**
     * 根据考试ID查询交卷人数
     */
    int submitCount(Long examId);

    /**
     * 查询应考人数
     */
    Integer selectCountGroupByAccountId(Long companyId);

    /**
     * 获取考试通过人数
     */
    Integer selectByCount(Long examId);

    /**
     * 获取考试总人数和总分数用来计算平均分和完成率
     */
    StatisticalCountVO selectStaticalCount(Long examId);


    List<AnswerDetailVO> getAnswerDetailList(ExamAnswerByUserVO vo);

    /**
     * 查询考生某场考试的最高分
     *
     * @param accountId 考生ID
     * @param examId    考试ID
     * @return
     */
    TrExamAnswer selectMaxScoreByAccountIdAndExamId(Long accountId, Long examId);

    /**
     * 获取已参加的考试次数（已提交和已阅卷）
     *
     * @param accountId 考生ID
     * @param examId    考试ID
     * @return
     */
    List<Long> getAnswerDetailListInfo(Long accountId, Long examId);

    AnswerQuestionListVO answerMainQuestionDetailByAnswerQuestionId(Long answerQuestionId);

    /**
     * 查找所有没提交的考试
     *
     * @param companyId
     * @return
     */
    List<TrExamAnswer> getUnSubmitExam(Long companyId);

    Integer getFullScore(Long examId, Long answerQuesionId);


    List<TrExamAnswer> getEarlyPassExamIdByExamIds(List<Long> listIds);

    List<Long> getFinishedAccountIds(Long examId, Long companyId, Long siteId);

    /**
     * 查找必答题分值
     *
     * @param answerId
     * @param examId
     * @return
     */
    Map<Long, Map<String, BigDecimal>> getQuestionFullScoreMap(Long answerId, Long examId);

    /**
     * 查找系统出题分值
     *
     * @param examId
     * @return
     */
    Map<Integer, Map<String, BigDecimal>> getSystemQuestionFullScoreMap(Long examId);
    
    /**
     * 根据siteId和时间段获取考试结果集
     * @param siteId
     * @param from
     * @param to
     * @return
     */
    public List<TrExamAnswer> getBySiteAndDateScope(Long siteId, Date from, Date to);
    
    /**
	 * 获取dash board数据
	 * @param query
	 * @return Map<学员ID, 考试累计时长>
	 */
	public Map<Long, Integer> getExamDashboardData(ExamDashboardQueryVO query);
}


