package com.yizhi.application.service;

import com.baomidou.mybatisplus.service.IService;
import com.yizhi.application.domain.TrExamScoreEvaluate;
import com.yizhi.exam.application.vo.TrExamScoreEvaluateVO;

import java.util.List;

/**
 * <p>
 * 考试分数通用评价 服务类
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
public interface ITrExamScoreEvaluateService extends IService<TrExamScoreEvaluate> {

	/**
	 * 新建
	 * @param trExamScoreEvaluateVoList
	 * @param examId
	 * @return
	 */
	boolean updateTrExamScoreEvaluateList(List<TrExamScoreEvaluateVO> trExamScoreEvaluateVoList, Long examId);

	/**
	 * 复制
	 * @param oldExamId
	 * @param examId
	 * @return
	 */
	boolean copyTrExamScoreEvaluate(Long oldExamId, Long examId);

	/**
	 * 考试分数通用评价 list
	 * @param examId
	 * @return
	 */
	List<TrExamScoreEvaluateVO> listTrExamScoreEvaluate(Long examId);
	
	/**
	 * 新增所有考试通用分评价
	 * */
	boolean insertAll(List<TrExamScoreEvaluate> trExamScoreEvaluates);

}