package com.yizhi.application.service.impl;


import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.application.domain.QuestionLibrary;
import com.yizhi.application.domain.TrQuestionLibrarySubject;
import com.yizhi.application.domain.TrQuestionSubjectOption;
import com.yizhi.exam.application.vo.*;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.application.mapper.QuestionLibraryMapper;
import com.yizhi.application.mapper.TrQuestionLibrarySubjectMapper;
import com.yizhi.application.mapper.TrQuestionSubjectOptionMapper;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.service.IQuestionLibraryService;
import com.yizhi.util.application.date.DateUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 题库 服务实现类
 * </p>
 *
 * @author HUIHUI.DUAN
 * @since 2018-03-13
 */
@Service
@Transactional
public class QuestionLibraryServiceImpl extends ServiceImpl<QuestionLibraryMapper, QuestionLibrary> implements IQuestionLibraryService {

    private static Logger logger = LoggerFactory.getLogger(QuestionLibraryServiceImpl.class);
    private static final String[] properties = new String[]{"stem", "typeValue", "isAnswer", "analysis", "questionLabel", "name", "content1", "content2", "content3", "content4"};
    private Long queId = null;
    @Autowired
    IdGenerator idGenerator;
    @Autowired
    QuestionLibraryMapper questionLibraryMapper;
    @Autowired
    TrQuestionLibrarySubjectMapper trQuestionLibrarySubjectMapper;
    @Autowired
    TrQuestionSubjectOptionMapper trQuestionSubjectOptionMapper;
    @Autowired
    private RedisTemplate redisTemplate;

    @Override
    public Boolean importQuestionLibrary(MultipartFile file, Long id) {
   		/*ExcelImporter excelImporter = (ExcelImporter) ExcelImporter.build(file.getOriginalFilename(),"C:\\file\\dir", file.getName(),  properties, this);
   		excelImporter.handle();*/
        return true;
    }


    @Override
    public Boolean importQuestionLibrary(String file, String fileName, Long id) {

   		/*ExcelImporter excelImporter = (ExcelImporter) ExcelImporter.build(file, "C:\\file\\dir", fileName, properties, this);
   		this.setQueId(id);
   		excelImporter.handle();*/
        return true;
    }

    @Override
    public int selectLibraryCount(ContextAndPageSizeVO contextAndPageSizeVO, List<Long> managerIds) {
        return questionLibraryMapper.listLibraryVOCount(contextAndPageSizeVO, managerIds);
    }

    public void insertDb(List<ExamImportVO> listExam) throws Exception {

        QuestionLibrary questionLibrary = null;
        TrQuestionLibrarySubject trQuestionLibrarySubject = null;
        for (ExamImportVO que : listExam) {
            questionLibrary = new QuestionLibrary();
            trQuestionLibrarySubject = new TrQuestionLibrarySubject();
            if ("单选题".equals(que.getTypeValue())) {
                que.setType(1);
            }
            if ("多选题".equals(que.getTypeValue())) {
                que.setType(2);
            }
            if ("判断题".equals(que.getTypeValue())) {
                que.setType(3);
            }
            if ("问答题".equals(que.getTypeValue())) {
                que.setType(4);
            }
            questionLibrary.setName(que.getName());
            if (StringUtils.isEmpty(questionLibrary.getName())) {
                logger.error("题库名称不能为空");
                //throw  new BizException(ReturnCode.QUESTION_LIBRARY_FAIL);
            }
            questionLibrary = questionLibraryMapper.selectOne(questionLibrary);
            if (questionLibrary != null) {
                questionLibrary.setCreateByName("develop");
                questionLibrary.setUpdateById(0L);
                questionLibrary.setUpdateByName("develop");
                questionLibraryMapper.updateById(questionLibrary);
            } else {
                questionLibrary = new QuestionLibrary();
                BeanUtils.copyProperties(que, questionLibrary);
                questionLibrary.setLibraryNo(getNumber());
                questionLibrary.setOrgId(0L);
                questionLibrary.setSiteId(0L);
                questionLibrary.setCompanyId(0L);
                questionLibrary.setCreateById(0L);
                questionLibrary.setCreateByName("develop");
                questionLibrary.setUpdateById(0L);
                questionLibrary.setUpdateByName("develop");
                questionLibrary.setId(this.getQueId());
                questionLibraryMapper.updateById(questionLibrary);
            }

            trQuestionLibrarySubject.setStem(que.getStem());
            if (StringUtils.isEmpty(trQuestionLibrarySubject.getStem())) {
                //throw  new BizException(ReturnCode.STEM_FAIL);
            }
            trQuestionLibrarySubject = trQuestionLibrarySubjectMapper.selectOne(trQuestionLibrarySubject);
            if (trQuestionLibrarySubject != null) {
                trQuestionLibrarySubject.setCreateByName("develop");
                trQuestionLibrarySubject.setUpdateById(0L);
                trQuestionLibrarySubject.setUpdateByName("develop");
                trQuestionLibrarySubjectMapper.updateById(trQuestionLibrarySubject);
                continue;
            }
            trQuestionLibrarySubject = new TrQuestionLibrarySubject();
            BeanUtils.copyProperties(que, trQuestionLibrarySubject);
            trQuestionLibrarySubject.setId(idGenerator.generate());
            trQuestionLibrarySubject.setLibraryId(questionLibrary.getId());
            trQuestionLibrarySubject.setOrgId(0L);
            trQuestionLibrarySubject.setSiteId(0L);
            trQuestionLibrarySubject.setScoreRule(que.getIsAnswer());
            trQuestionLibrarySubject.setCompanyId(0L);
            trQuestionLibrarySubject.setCreateById(0L);
            trQuestionLibrarySubject.setCreateByName("develop");
            trQuestionLibrarySubject.setUpdateById(0L);
            trQuestionLibrarySubject.setUpdateByName("develop");
            trQuestionLibrarySubjectMapper.insert(trQuestionLibrarySubject);


            if (StringUtils.isNotEmpty(que.getContent1())) {
                TrQuestionSubjectOption trQuestionSubjectOption1 = new TrQuestionSubjectOption();
                trQuestionSubjectOption1.setSubjectId(trQuestionLibrarySubject.getId());
                if (que.getIsAnswer().contains("A") || "A".equals(que.getIsAnswer())) {
                    trQuestionSubjectOption1.setIsAnswer(1);

                }
                if ("对".equals(que.getIsAnswer())) {
                    trQuestionSubjectOption1.setIsAnswer(1);

                }
                trQuestionSubjectOption1.setId(idGenerator.generate());
                trQuestionSubjectOption1.setContent(que.getContent1());
                trQuestionSubjectOption1.setCreateById(0L);
                trQuestionSubjectOption1.setCreateByName("develop");
                trQuestionSubjectOption1.setUpdateById(0L);
                trQuestionSubjectOption1.setUpdateByName("develop");
                trQuestionSubjectOptionMapper.insert(trQuestionSubjectOption1);
            }
            if (StringUtils.isNotEmpty(que.getContent2())) {
                TrQuestionSubjectOption trQuestionSubjectOption2 = new TrQuestionSubjectOption();
                if (que.getIsAnswer().contains("B") || "B".equals(que.getIsAnswer())) {
                    trQuestionSubjectOption2.setIsAnswer(1);

                }
                if ("错".equals(que.getIsAnswer())) {
                    trQuestionSubjectOption2.setIsAnswer(1);

                }
                trQuestionSubjectOption2.setSubjectId(trQuestionLibrarySubject.getId());
                trQuestionSubjectOption2.setId(idGenerator.generate());
                trQuestionSubjectOption2.setContent(que.getContent2());
                trQuestionSubjectOption2.setCreateById(0L);
                trQuestionSubjectOption2.setCreateByName("develop");
                trQuestionSubjectOption2.setUpdateById(0L);
                trQuestionSubjectOption2.setUpdateByName("develop");
                trQuestionSubjectOptionMapper.insert(trQuestionSubjectOption2);
            }
            if (StringUtils.isNotEmpty(que.getContent3())) {
                TrQuestionSubjectOption trQuestionSubjectOption3 = new TrQuestionSubjectOption();
                if (que.getIsAnswer().contains("C") || "C".equals(que.getIsAnswer())) {
                    trQuestionSubjectOption3.setIsAnswer(1);

                }
                trQuestionSubjectOption3.setSubjectId(trQuestionLibrarySubject.getId());
                trQuestionSubjectOption3.setId(idGenerator.generate());
                trQuestionSubjectOption3.setContent(que.getContent3());
                trQuestionSubjectOption3.setCreateById(0L);
                trQuestionSubjectOption3.setCreateByName("develop");
                trQuestionSubjectOption3.setUpdateById(0L);
                trQuestionSubjectOption3.setUpdateByName("develop");
                trQuestionSubjectOptionMapper.insert(trQuestionSubjectOption3);
            }
            if (StringUtils.isNotEmpty(que.getContent4())) {
                TrQuestionSubjectOption trQuestionSubjectOption4 = new TrQuestionSubjectOption();
                if (que.getIsAnswer().contains("D") || "D".equals(que.getIsAnswer())) {
                    trQuestionSubjectOption4.setIsAnswer(1);

                }
                trQuestionSubjectOption4.setSubjectId(trQuestionLibrarySubject.getId());
                trQuestionSubjectOption4.setId(idGenerator.generate());
                trQuestionSubjectOption4.setContent(que.getContent4());
                trQuestionSubjectOption4.setCreateById(0L);
                trQuestionSubjectOption4.setCreateByName("develop");
                trQuestionSubjectOption4.setUpdateById(0L);
                trQuestionSubjectOption4.setUpdateByName("develop");
                trQuestionSubjectOptionMapper.insert(trQuestionSubjectOption4);
            }
        }

    }

    public List<QuestionLibrary> getQuestionLibraryList(Integer pageSize, Integer pageNo) {
        // TODO Auto-generated method stub
        Integer start = (pageNo - 1) * pageSize;
        Integer end = pageSize * pageNo;
        System.out.println(start);
        System.out.println(end);
        return questionLibraryMapper.getQuestionLibraryList(start, end);

    }

    @Override
    public Integer sumNum() {
        // TODO Auto-generated method stub
        Long siteId = 0L;  //先根据siteid=0
        return questionLibraryMapper.sumNum(siteId);
    }

    @Override
    public boolean insertQuestionLibraryAndTrQuestionLibrarySubjectService(QuestionLibraryVO questionLibraryVO) {
        int questionLibraryCount = 0;
        int questionLibraryLibrarySubjectCount = 0;
        int questionSubjectOptionCount = 0;
        Date createTime = new Date();
        TrQuestionLibrarySubject trQuestionLibrarySubject = null;
        TrQuestionSubjectOption trQuestionSubjectOption = null;

        try {
            QuestionLibrary questionLibrary = new QuestionLibrary();
            BeanUtils.copyProperties(questionLibraryVO, questionLibrary);
            questionLibrary.setState(1);
            questionLibrary.setCreateById(questionLibraryVO.getAccountId());
            questionLibrary.setCreateByName(questionLibraryVO.getAccountName());
            questionLibrary.setCreateTime(createTime);
            questionLibrary.setUpdateById(questionLibraryVO.getAccountId());
            questionLibrary.setUpdateByName(questionLibraryVO.getAccountName());
            questionLibrary.setUpdateTime(createTime);
            questionLibrary.setOrgId(questionLibraryVO.getOrgId());
            questionLibrary.setSiteId(questionLibraryVO.getSiteId());
            questionLibrary.setCompanyId(questionLibraryVO.getCompanyId());
            questionLibrary.setLibraryNo(getNumber());
            // 新增题库
            int result = questionLibraryCount = questionLibraryMapper.insert(questionLibrary);
            if (result > 0) {
                return true;
            } else {
                return false;
            }
		/*	if (questionLibraryCount > 0) {
				List<QuestionLibrarySubjectVO> questionLibrarySubjectVOS = questionLibraryVO
						.getQuestionLibrarySubjectVOS();
				if (null != questionLibrarySubjectVOS) {
					for (QuestionLibrarySubjectVO questionLibrarySubjectVO : questionLibrarySubjectVOS) {
						trQuestionLibrarySubject = new TrQuestionLibrarySubject();
						BeanUtils.copyProperties(questionLibrarySubjectVO, trQuestionLibrarySubject);
						trQuestionLibrarySubject.setId(idGenerator.generate());
						trQuestionLibrarySubject.setLibraryId(questionLibrary.getId());
						trQuestionLibrarySubject.setCompanyId(companyId);
						trQuestionLibrarySubject.setSiteId(siteId);
						trQuestionLibrarySubject.setCreateById(accountId);
						trQuestionLibrarySubject.setCreateByName(accountName);
						trQuestionLibrarySubject.setUpdateById(accountId);
						trQuestionLibrarySubject.setUpdateByName(accountName);
						trQuestionLibrarySubject.setUpdateTime(createTime);
						trQuestionLibrarySubject.setOrgId(orgId);

						// 新增试题
						trQuestionLibrarySubjectMapper.updateById(trQuestionLibrarySubject);
						questionLibraryLibrarySubjectCount = trQuestionLibrarySubjectMapper
								.insert(trQuestionLibrarySubject);

						// 问答题不用对选项进行操作
						if (questionLibraryLibrarySubjectCount > 0 && questionLibrarySubjectVO.getType() != 4) {
							List<QuestionSubjectOptionVO> questionSubjectOptionVOS = questionLibrarySubjectVO
									.getQuestionSubjectOptionVOList();
							int sort = 0;
							if (null != questionSubjectOptionVOS) {
								// 用于排序
								sort++;
								for (QuestionSubjectOptionVO questionSubjectOptionVO : questionSubjectOptionVOS) {
									trQuestionSubjectOption = new TrQuestionSubjectOption();
									BeanUtils.copyProperties(questionSubjectOptionVO, trQuestionSubjectOption);
									trQuestionSubjectOption.setId(idGenerator.generate());
									trQuestionSubjectOption.setSubjectId(trQuestionLibrarySubject.getId());
									trQuestionSubjectOption.setSort(sort);
									trQuestionSubjectOption.setCreateById(accountId);
									trQuestionSubjectOption.setCreateByName(accountName);
									trQuestionSubjectOption.setUpdateById(accountId);
									trQuestionSubjectOption.setUpdateByName(accountName);
									trQuestionSubjectOption.setUpdateTime(createTime);

									// 新增选项
									questionSubjectOptionCount = trQuestionSubjectOptionMapper
											.insert(trQuestionSubjectOption);
								}
							}
						}
					}
				}
			}*/
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean updateQuestionLibraryAmdTrQuestionLibrarySubjectService(QuestionLibraryVO questionLibraryVO) {
        int questionLibraryCount = 0;
        int questionLibraryLibrarySubjectCount = 0;
        int questionSubjectOptionCount = 0;
        Date createTime = new Date();
        TrQuestionLibrarySubject trQuestionLibrarySubject = null;
        TrQuestionSubjectOption trQuestionSubjectOption = null;
        try {
            QuestionLibrary questionLibrary = new QuestionLibrary();
            BeanUtils.copyProperties(questionLibraryVO, questionLibrary);
            questionLibrary.setUpdateById(questionLibraryVO.getAccountId());
            questionLibrary.setUpdateByName(questionLibraryVO.getAccountName());
            questionLibrary.setUpdateTime(createTime);
            questionLibrary.setLibraryNo(getNumber());

            // 修改题库
            questionLibraryCount = questionLibraryMapper.updateById(questionLibrary);

				/*List<QuestionLibrarySubjectVO> questionLibrarySubjectVOS = questionLibraryVO
						.getQuestionLibrarySubjectVOS();
				if (null != questionLibrarySubjectVOS) {
					for (QuestionLibrarySubjectVO questionLibrarySubjectVO : questionLibrarySubjectVOS) {
						trQuestionLibrarySubject = new TrQuestionLibrarySubject();
						BeanUtils.copyProperties(questionLibrarySubjectVO, trQuestionLibrarySubject);
						trQuestionLibrarySubject.setLibraryId(questionLibrary.getId());
						trQuestionLibrarySubject.setCompanyId(questionLibraryVO.getCompanyId());
						trQuestionLibrarySubject.setSiteId(questionLibraryVO.getSiteId());
						trQuestionLibrarySubject.setOrgId(questionLibraryVO.getOrgId());
*/
            // 判断是新增试题还是修改试题
						/*if (null != trQuestionLibrarySubject.getId()) {
							trQuestionLibrarySubject.setUpdateById(questionLibraryVO.getAccountId());
							trQuestionLibrarySubject.setUpdateByName(questionLibraryVO.getAccountName());
							trQuestionLibrarySubject.setUpdateTime(createTime);
							questionLibraryLibrarySubjectCount = trQuestionLibrarySubjectMapper
									.updateById(trQuestionLibrarySubject);
						} else {
							trQuestionLibrarySubject.setId(idGenerator.generate());
							trQuestionLibrarySubject.setCreateById(questionLibraryVO.getAccountId());
							trQuestionLibrarySubject.setCreateByName(questionLibraryVO.getAccountName());
							trQuestionLibrarySubject.setUpdateById(questionLibraryVO.getAccountId());
							trQuestionLibrarySubject.setUpdateByName(questionLibraryVO.getAccountName());
							trQuestionLibrarySubject.setUpdateTime(createTime);
							questionLibraryLibrarySubjectCount = trQuestionLibrarySubjectMapper
									.insert(trQuestionLibrarySubject);
						}*/

            // 问答题不用对选项进行操作
						/*if (questionLibraryLibrarySubjectCount > 0 && questionLibrarySubjectVO.getType() != 4) {
							List<QuestionSubjectOptionVO> questionSubjectOptionVOS = questionLibrarySubjectVO
									.getQuestionSubjectOptionVOList();
							int sort = 0;
							if (null != questionSubjectOptionVOS) {*/
            // 用于排序
								/*sort++;
								for (QuestionSubjectOptionVO questionSubjectOptionVO : questionSubjectOptionVOS) {
									trQuestionSubjectOption = new TrQuestionSubjectOption();
									BeanUtils.copyProperties(questionSubjectOptionVO, trQuestionSubjectOption);
									trQuestionSubjectOption.setSubjectId(trQuestionLibrarySubject.getId());
									trQuestionSubjectOption.setSort(sort);
									trQuestionSubjectOption.setUpdateById(questionLibraryVO.getAccountId());
									trQuestionSubjectOption.setUpdateByName(questionLibraryVO.getAccountName());
									trQuestionSubjectOption.setUpdateTime(createTime);
*/
            // 判断是新增选项还是修改选项
									/*if (null != trQuestionSubjectOption.getId()) {
										questionSubjectOptionCount = trQuestionSubjectOptionMapper
												.updateById(trQuestionSubjectOption);
									} else {
										trQuestionSubjectOption.setId(idGenerator.generate());
										trQuestionSubjectOption.setCreateTime(createTime);
										trQuestionSubjectOption.setCreateById(questionLibraryVO.getAccountId());
										trQuestionSubjectOption.setCreateByName(questionLibraryVO.getAccountName());
										trQuestionSubjectOption.setUpdateById(questionLibraryVO.getAccountId());
										trQuestionSubjectOption.setUpdateByName(questionLibraryVO.getAccountName());
										trQuestionSubjectOption.setUpdateTime(createTime);
										questionSubjectOptionCount = trQuestionSubjectOptionMapper
												.insert(trQuestionSubjectOption);
									}
								}
							}
						}
					}
				}*/
            if (questionLibraryCount > 0) {
                return true;
            }
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public int libraryState(Long libraryId, Long subjectId) {
        int count = questionLibraryMapper.libraryState(subjectId);
        if (count == 0) {
            count = questionState(subjectId, null, null, null);
        }
        if (count == 0) {
            count = examCountBySubjectId(subjectId);
        }
        return count;
    }

    @Override
    public int questionState(Long questionId, Long companyId, Long orgId, Long siteId) {
        int count = questionLibraryMapper.questionState(questionId, companyId, orgId, siteId);
        if (count > 1) {
            count = 1;
        }
        return count;
    }

    @Override
    public List<ListLibraryVO> getList(ContextAndPageSizeVO contextAndPageSizeVO, List<Long> managerIds) {
        // TODO Auto-generated method stub
        int start = (contextAndPageSizeVO.getPageNo() - 1) * contextAndPageSizeVO.getPageSize();
        RequestContext res = ContextHolder.get();
        contextAndPageSizeVO.setPageNo(start);
        List<ListLibraryVO> listLibraryVOS = questionLibraryMapper.listLibrary(contextAndPageSizeVO, managerIds);
        if (!CollectionUtils.isEmpty(listLibraryVOS)){
            List<Long> ids = listLibraryVOS.stream().map(ListLibraryVO::getId).collect(Collectors.toList());
            List<TypeAndCountVo> typeAndCountVos = questionLibraryMapper.selectTypeAndCount(ids);
            List<TypeAndCountVo> typeAndCountVos1;
            for (ListLibraryVO listLibraryVO : listLibraryVOS) {
                typeAndCountVos1 = new ArrayList<TypeAndCountVo>();
                for (TypeAndCountVo typeAndCountVo : typeAndCountVos) {
                    if (typeAndCountVo.getId().equals(listLibraryVO.getId())) {
                        typeAndCountVos1.add(typeAndCountVo);
                    }
                }
                listLibraryVO.setTypeAndCountVoList(typeAndCountVos1);
            }
        }
        return listLibraryVOS;
    }

	/*@Override
    public Boolean exec(TaskContext ctx, List object) {
		List<Map<String, String>> list = (List<Map<String, String>>) object;
		List<ExamImportVO> listExam = JsonUtil.json2List( JsonUtil.object2Json(list), ExamImportVO.class);
		try {
			insertDb(listExam);
		} catch (Exception e) {
			logger.error("导入题库试题解析exel保存数据失败", e);
			return false;
		}
		return true;
	}*/


    public Long getQueId() {
        return queId;
    }


    public void setQueId(Long queId) {
        this.queId = queId;
    }

    @Override
    public Boolean libDelete(Long id) {
        QuestionLibrary questionLibrary = new QuestionLibrary();
        questionLibrary.setId(id);
        questionLibrary = questionLibraryMapper.selectOne(questionLibrary);
        if (questionLibrary == null || questionLibrary.getState() == 2) {
            return false;
        }
        questionLibrary.setState(0);
        questionLibraryMapper.updateById(questionLibrary);
        return true;
    }

    @Override
    public Boolean libDeleteBatch(Long[] ids) {
        QuestionLibrary questionLibrary = null;
        for (int i = 0; i < ids.length; i++) {
            questionLibrary = new QuestionLibrary();
            questionLibrary.setId(ids[i]);
            questionLibrary = questionLibraryMapper.selectOne(questionLibrary);
            if (questionLibrary == null || questionLibrary.getState() == 2) {
                return false;
            }
            questionLibrary.setState(0);
            questionLibraryMapper.updateById(questionLibrary);
        }
        return true;
    }

    @Override
    public QuestionLibraryVO selectQuestionLibraryById(Long id) {
        QuestionLibraryVO questionLibraryVO = new QuestionLibraryVO();
        QuestionLibrary questionLibrary = questionLibraryMapper.selectById(id);
        BeanUtils.copyProperties(questionLibrary,questionLibraryVO);
        questionLibraryVO.setId(questionLibrary.getId());
        questionLibraryVO.setName(questionLibrary.getName());
        questionLibraryVO.setLibraryLabel(questionLibrary.getLibraryLabel());
        questionLibraryVO.setComments(questionLibrary.getComments());
        return questionLibraryVO;
    }

    @Override
    public QuestionLibrary nameIsExist(String name) {
        QuestionLibrary questionLibrary = new QuestionLibrary();
        questionLibrary.setName(name);
        questionLibrary.setState(1);
        EntityWrapper<QuestionLibrary> wrapper = new EntityWrapper<QuestionLibrary>(questionLibrary);
        QuestionLibrary obj = this.selectOne(wrapper);
        return obj;
    }


    @Override
    public int examCountBySubjectId(Long subjectId) {
        return questionLibraryMapper.examCountBySubjectId(subjectId);
    }

    @Override
    public List<TypeAndCountVo> getTypeAndCount(Long examId, Long libraryId) {
        return questionLibraryMapper.getTypeAndCount(examId, libraryId);
    }

    public String getNumber(){
        Long numVal = getIncrement("question:number");
        NumberFormat formatter = NumberFormat.getNumberInstance();
        formatter.setMinimumIntegerDigits(4);
        formatter.setGroupingUsed(false);
        String idStr = formatter.format(numVal);
        return String.join(DateUtil.format(new Date(),"yyyy"), "TK", idStr);
    }

    /**
     * 获取自增数据
     *
     * @param key
     * @return
     */
    public Long getIncrement(String key) {
        ValueOperations<String, Long> valueOperations = redisTemplate.opsForValue();
        Long t = redisTemplate.getExpire(key);
        return ObjectUtil.isEmpty(t) ? valueOperations.increment(key) : valueOperations.increment(key,t);
    }
}
