package com.yizhi.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.application.constant.ExamConstant;
import com.yizhi.application.domain.*;
import com.yizhi.application.mapper.*;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.service.*;
import com.yizhi.exam.application.vo.TrExamPointVO;
import com.yizhi.exam.application.vo.TrExamScoreEvaluateVO;
import com.yizhi.exam.application.vo.exam.*;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;

/**
 * <p>
 * 答案题目 服务实现类
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
@Service
@Transactional
public class TrExamAnswerQuestionServiceImpl extends ServiceImpl<TrExamAnswerQuestionMapper, TrExamAnswerQuestion>
        implements ITrExamAnswerQuestionService {

    private final static Logger LOGGER = LoggerFactory.getLogger(TrExamAnswerQuestionServiceImpl.class);

    @Autowired
    private IdGenerator idGenerator;
    @Autowired
    private ITrExamAnswerService trExamAnswerService;
    @Autowired
    private ITrExamAnswerQuestionResService trExamAnswerQuestionResService;
    @Autowired
    private ITrExamAnswerQuestionResMaService trExamAnswerQuestionResMaService;
    @Autowired
    private ITrQuestionSubjectOptionService trQuestionSubjectOptionService;
    @Autowired
    private ITrQuestionLibrarySubjectService trQuestionLibrarySubjectService;
    @Autowired
    private IExamService examService;
    @Autowired
    private StudentExamPaperServiceImpl studentExamPaperService;
    @Autowired
    private TrExamAnswerQuestionMapper trExamAnswerQuestionMapper;
    @Autowired
    private ITrExamAnswerQuestionService iTrExamAnswerQuestionService;
    @Autowired
    private ITrExamQuestionService iTrExamQuestionService;
    @Autowired
    private ITrExamOnlineReadOverService iTrExamOnlineReadOverService;
    @Autowired
    private ITrExamPointService iTrExamPointService;
    @Autowired
    private ITrExamScoreEvaluateService iTrExamScoreEvaluateService;

    @Autowired
    private TrExamAnswerMapper trExamAnswerMapper;

    @Autowired
    IStudentExamPaperService iStudentExamPaperService;

    @Autowired
    ExamStudentAutoAnswerInfoMapper examStudentAutoAnswerInfoMapper;

    @Autowired
    TrExamOnlineReadOverMapper examOnlineReadOverMapper;

    @Autowired
    ExamPaperMapper examPaperMapper;

    /**
     * @param vo
     * @return
     */
    @Transactional(propagation = Propagation.REQUIRED)
    public boolean saveExamAnswerOld(ExamAnswerVO vo) {
        Long answerId = vo.getAnswerId();
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("answer_id", answerId);
		/*map.put("answer_question_id", "tr_exam_answer_question.id");
		map.put("option_id", "tr_exam_answer_question_res.option_id");*/
        Date time = new Date();
        //删除客观题答案选项
        trExamAnswerQuestionResService.deleteByMap(map);
        //删除主观题答案选项
        trExamAnswerQuestionResMaService.deleteByMap(map);

        //客观题
        List<TrExamAnswerQuestionRes> resList = new ArrayList<TrExamAnswerQuestionRes>();
        //主观题
        List<TrExamAnswerQuestionResMa> resMaList = new ArrayList<TrExamAnswerQuestionResMa>();

        List<ExamProgressVO> voList = vo.getEpList();
        TrExamAnswerQuestion trExamAnswerQuestion = new TrExamAnswerQuestion();
        TrExamAnswerQuestionResMa ma = null;
        TrExamAnswerQuestionRes res = null;
        int indexOption = 0;//项目排序
        for (ExamProgressVO epVo : voList) {
            //保存题目标记
            trExamAnswerQuestion.setId(epVo.getAnsQId());
            trExamAnswerQuestion.setMark(epVo.getMark());
            trExamAnswerQuestion.setUpdateTime(time);
            trExamAnswerQuestion.setUpdateById(vo.getAccountId());
            //trExamAnswerQuestion.setUpdateByName(vo.getAccountName());
            trExamAnswerQuestion.setUpdateByName("");
            boolean result = this.updateById(trExamAnswerQuestion);
            //主观题
            if (ExamConstant.FOUR.compareTo(epVo.getType()) == 0) {
                ma = new TrExamAnswerQuestionResMa();
                ma.setId(idGenerator.generate());
                ma.setAnswerId(answerId);
                ma.setAnswerQuestionId(epVo.getAnsQId());
                ma.setAnswer(epVo.getSub());
                ma.setCreateById(vo.getAccountId());
                //ma.setCreateByName(vo.getAccountName());
                ma.setCreateByName("");
                ma.setUpdateById(vo.getAccountId());
                //ma.setUpdateByName(vo.getAccountName());
                ma.setUpdateByName("");
                ma.setCreateTime(time);
                ma.setUpdateTime(time);
//				trExamAnswerQuestionResMaService.setInsertCloumn(ma);
                resMaList.add(ma);
            } else {
                List<StudentOptionVO> ops = epVo.getOps();
                if (ops.size() > 0) {
                    indexOption = 0;
                    for (StudentOptionVO soVo : ops) {
                        res = new TrExamAnswerQuestionRes();
                        res.setId(idGenerator.generate());
                        res.setAnswerId(answerId);
                        res.setAnswerQuestionId(epVo.getAnsQId());
                        res.setOptionId(soVo.getOptionId());
                        res.setAnswer(soVo.getAnswer());
                        res.setRightAnswer(trQuestionSubjectOptionService.selectById(soVo.getOptionId()).getIsAnswer());
                        res.setCreateById(vo.getAccountId());
                        //res.setCreateByName(vo.getAccountName());
                        res.setCreateByName("");
                        res.setUpdateById(vo.getAccountId());
                        //res.setUpdateByName(vo.getAccountName());
                        res.setUpdateByName("");
                        res.setSort(indexOption++);
                        res.setCreateTime(time);
                        res.setUpdateTime(time);
//						trExamAnswerQuestionResService.setInsertCloumn(res);
                        resList.add(res);
                    }
                }
            }
        }
        if (resList.size() > 0) {
            trExamAnswerQuestionResService.insertBatch(resList);
        }
        if (resMaList.size() > 0) {
            trExamAnswerQuestionResMaService.insertBatch(resMaList);
        }
        return true;
    }

    /**
     * @param vo
     * @return
     */
    @Transactional(propagation = Propagation.REQUIRED)
    public boolean saveExamAnswer(ExamAnswerVO vo) {
        LOGGER.info("保存考试:参数: {}", JSONObject.toJSONString(vo));
        Long answerId = vo.getAnswerId();
        TrExamAnswer trExamAnswer = trExamAnswerService.selectById(answerId);
        if (trExamAnswer.getState() > 0){
            return false;
        }
        
        Date time = new Date();

        //客观题
        List<TrExamAnswerQuestionRes> resList = new ArrayList<TrExamAnswerQuestionRes>();
        //主观题
        List<TrExamAnswerQuestionResMa> resMaList = new ArrayList<TrExamAnswerQuestionResMa>();

        //客观题
        List<TrExamAnswerQuestionRes> updateResList = new ArrayList<TrExamAnswerQuestionRes>();
        //主观题
        List<TrExamAnswerQuestionResMa> updateResMaList = new ArrayList<TrExamAnswerQuestionResMa>();

        List<ExamProgressVO> voList = vo.getEpList();
        TrExamAnswerQuestion trExamAnswerQuestion = new TrExamAnswerQuestion();
        TrExamAnswerQuestionResMa ma = null;
        TrExamAnswerQuestionRes res = null;
        int indexOption = 0;//项目排序
        // 客观题
        List<TrExamAnswerQuestionRes> selectResList = null;
        // 主观题
        TrExamAnswerQuestionResMa selectResMa = null;
        Long questionId = null;
        for (ExamProgressVO epVo : voList) {
            //保存题目标记
            questionId = epVo.getAnsQId();
            trExamAnswerQuestion.setId(questionId);
            trExamAnswerQuestion.setMark(epVo.getMark());
            trExamAnswerQuestion.setUpdateTime(time);
            trExamAnswerQuestion.setUpdateById(vo.getAccountId());
            if (null != vo.getAccountName()) {
                //trExamAnswerQuestion.setUpdateByName(vo.getAccountName());
                trExamAnswerQuestion.setUpdateByName("");
            }
            boolean result = this.updateById(trExamAnswerQuestion);
            //主观题
            if (null != epVo.getType() && ExamConstant.FOUR.compareTo(epVo.getType()) == 0) {
                selectResMa = trExamAnswerQuestionResMaService.selectAnswerQuestionOptionMainByAnswerIdAndQuestionId(answerId, questionId);
                if (selectResMa == null) {
                    //新增
                    ma = new TrExamAnswerQuestionResMa();
                    ma.setId(idGenerator.generate());
                    ma.setAnswerId(answerId);
                    ma.setAnswerQuestionId(questionId);
                    ma.setAnswer(epVo.getSub());
                    ma.setCreateById(vo.getAccountId());
                    //ma.setCreateByName(vo.getAccountName());
                    ma.setCreateByName("");
                    ma.setUpdateById(vo.getAccountId());
                    //ma.setUpdateByName(vo.getAccountName());
                    ma.setUpdateByName("");
                    ma.setCreateTime(time);
                    ma.setUpdateTime(time);
//					trExamAnswerQuestionResMaService.setInsertCloumn(ma);
                    resMaList.add(ma);
                } else {
                    //更新时判断是否作答了，作答了才更新
                    Boolean isAnswer = epVo.getIsAnswer();
                    if (isAnswer == null) {
                        isAnswer = true;
                    }
                    if (isAnswer) {
                        selectResMa.setAnswer(epVo.getSub());
                        selectResMa.setCreateById(vo.getAccountId());
                        //selectResMa.setUpdateByName(vo.getAccountName());
                        selectResMa.setUpdateByName("");
                        selectResMa.setUpdateTime(time);
                        updateResMaList.add(selectResMa);
                    }
                }

            } else {
                List<StudentOptionVO> ops = epVo.getOps();
                if (ops.size() > 0) {
                    indexOption = 0;
                    selectResList = trExamAnswerQuestionResService.selectAnswerQuestionOptionByAnswerIdAndQuestionId(answerId, questionId);
                    if (selectResList == null || selectResList.size() == 0) {
                        //添加新记录
                        for (StudentOptionVO soVo : ops) {
                            res = new TrExamAnswerQuestionRes();
                            res.setId(idGenerator.generate());
                            res.setAnswerId(answerId);
                            res.setAnswerQuestionId(questionId);
                            res.setOptionId(soVo.getOptionId());
                            res.setAnswer(soVo.getAnswer());
                            TrQuestionSubjectOption trQuestionSubjectOption = trQuestionSubjectOptionService.selectById(soVo.getOptionId());
                            res.setRightAnswer(trQuestionSubjectOption == null ? 0 : trQuestionSubjectOption.getIsAnswer());
                            res.setCreateById(vo.getAccountId());
                            //res.setCreateByName(vo.getAccountName());
                            res.setCreateByName("");
                            res.setUpdateById(vo.getAccountId());
                            //res.setUpdateByName(vo.getAccountName());
                            res.setUpdateByName("");
                            res.setSort(indexOption++);
                            res.setCreateTime(time);
                            res.setUpdateTime(time);
//							trExamAnswerQuestionResService.setInsertCloumn(res);
                            resList.add(res);
                        }
                    } else {
                        //更新时判断是否作答了，作答了才更新
                        Boolean isAnswer = epVo.getIsAnswer();
                        if (isAnswer == null) {
                            isAnswer = true;
                        }
                        if (isAnswer) {
                            Long stuOptionId = null;
                            Long itemOptionId = null;
                            for (StudentOptionVO soVo : ops) {
                                stuOptionId = soVo.getOptionId();
                                for (TrExamAnswerQuestionRes item : selectResList) {
                                    itemOptionId = item.getOptionId();
                                    if (stuOptionId.compareTo(itemOptionId) == 0) {
                                        item.setAnswer(soVo.getAnswer());
                                        item.setUpdateById(vo.getAccountId());
                                        //item.setUpdateByName(vo.getAccountName());
                                        item.setUpdateByName("");
                                        item.setUpdateTime(time);
                                        updateResList.add(item);
                                        break;
                                    }
                                }
                            }
                        }
                    }

                }
            }
        }

        //批量添加
        if (resList.size() > 0) {
            LOGGER.info("保存学员accountId = {},accountName = {},examId = {},客观题考试答卷记录：参数: {}",vo.getAccountId(),vo.getAccountName(),vo.getExamId(),JSONObject.toJSONString(resList));
            trExamAnswerQuestionResService.insertBatch(resList);
        }
        if (resMaList.size() > 0) {
            LOGGER.info("保存学员accountId = {},accountName = {},examId = {},主观题考试答卷记录：参数: {}",vo.getAccountId(),vo.getAccountName(),vo.getExamId(),JSONObject.toJSONString(resMaList));
            trExamAnswerQuestionResMaService.insertBatch(resMaList);
        }

        //批量更新
        if (updateResList.size() > 0) {
            LOGGER.info("更新学员accountId = {},accountName = {},examId = {},客观题考试答卷记录：参数: {}",vo.getAccountId(),vo.getAccountName(),vo.getExamId(),JSONObject.toJSONString(updateResList));
            trExamAnswerQuestionResService.updateBatchById(updateResList);
        }
        if (updateResMaList.size() > 0) {
            LOGGER.info("更新学员accountId = {},accountName = {},examId = {},主观题考试答卷记录：参数: {}",vo.getAccountId(),vo.getAccountName(),vo.getExamId(),JSONObject.toJSONString(updateResMaList));
            trExamAnswerQuestionResMaService.updateBatchById(updateResMaList);
        }
        return true;
    }


    @Override
    @Transactional(propagation = Propagation.REQUIRED)
    public ExamResultVO submitExamPage(ExamAnswerVO vo) {

        LOGGER.info("*************************************考试提交answerId = {},入参ExamAnswerVO = {}", vo.getAnswerId(), JSONObject.toJSONString(vo));
        //先查看该场考试是否提交了,避免多终端重复提交
        TrExamAnswer trExamAnswer = trExamAnswerService.selectById(vo.getAnswerId());
        if (null != trExamAnswer && (trExamAnswer.getState() == 1 || trExamAnswer.getState() == 2)) {
            ExamResultVO erVo = new ExamResultVO();
            erVo.setIsExamAnswerGoOn(ExamConstant.EXAM_COMITED);
            return erVo;
        }

        Exam exam = examService.selectById(vo.getExamId());
        if (null != exam && exam.getAnswerNum() > 0) {
            TrExamAnswer trExamAnswer1 = new TrExamAnswer();
            trExamAnswer1.setAccountId(vo.getAccountId());
            trExamAnswer1.setExamId(vo.getExamId());
            EntityWrapper<TrExamAnswer> entityWrapper = new EntityWrapper<>(trExamAnswer1);
            entityWrapper.notIn("id", vo.getAnswerId());
            List<TrExamAnswer> trExamAnswerList = trExamAnswerService.selectList(entityWrapper);
            if (trExamAnswerList.size() >= exam.getAnswerNum()) {
                ExamResultVO ervo = new ExamResultVO();
                ervo.setIsExamAnswerGoOn(ExamConstant.EXAM_HAS_NO_TIMES);
                // 考试提交没有考试次数了,删除此次考卷信息并清空考试缓存信息
                try {
                    studentExamPaperService.clearStudentExam(vo.getAccountId(), vo.getExamId());
                } catch (Exception e) {
                    e.printStackTrace();
                }
                trExamAnswerService.deleteById(vo.getAnswerId());
                return ervo;
            }
        }

        //前端只提交作答的题库，未作答的不提交，这时要补全题目信息
        StudentExamPaperVO studentExamPaperVo = iStudentExamPaperService.getMakeStudentExam(vo.getAccountId(),
                vo.getExamId(), vo.getAnswerId(), 10L);
        ExamResultVO erVo = saveAnswer(studentExamPaperVo, vo);

        return erVo;
    }

    private ExamResultVO saveAnswer(StudentExamPaperVO studentExamPaperVo, ExamAnswerVO vo) {
        Date submitTime = new Date();

        Map<Long, BigDecimal> scoreMap = new HashMap<>();


        if (studentExamPaperVo != null) {
            ExamProgressVO examProVo = null;
            List<QuestionListVO> questLiist = studentExamPaperVo.getQuestions();
            if (CollectionUtils.isEmpty(questLiist)) {
                LOGGER.info("#########################questLiist为空,answerId{}", vo.getAnswerId());
            }
            if (questLiist != null && questLiist.size() > 0) {
                boolean isAnswer = false;
                List<ExamProgressVO> voList = vo.getEpList();
                if (voList == null) {
                    voList = new ArrayList<ExamProgressVO>();
                    vo.setEpList(voList);
                }
                List<ExamProgressVO> voNewList = null;
                Long answerQuestionId = null;
                Long ansQId = null;
                List<StudentOptionVO> ops = null;
                StudentOptionVO studentOptionVO = null;
                for (QuestionListVO item : questLiist) {
                    scoreMap.put(item.getSubjectId(), item.getScore());
                    isAnswer = false;
                    answerQuestionId = item.getAnswerQuestionId();
                    for (ExamProgressVO epVo : voList) {
                        ansQId = epVo.getAnsQId();
                        if (answerQuestionId.compareTo(ansQId) == 0) {
                            isAnswer = true;
                            epVo.setIsAnswer(isAnswer);
                            break;
                        }
                    }
                    if (!isAnswer) {
                        if (voNewList == null) {
                            voNewList = new ArrayList<ExamProgressVO>();
                        }
                        examProVo = new ExamProgressVO();
                        examProVo.setAnsQId(answerQuestionId);
                        examProVo.setIsAnswer(isAnswer);
                        examProVo.setSub("");
                        examProVo.setMark(0);
                        examProVo.setType(item.getType());

                        ops = new ArrayList<StudentOptionVO>();
                        for (QuestionOptionListVO qvo : item.getQuestionOptions()) {
                            studentOptionVO = new StudentOptionVO();
                            studentOptionVO.setAnswer(0);
                            studentOptionVO.setOptionId(qvo.getOptionId());
                            studentOptionVO.setSort(qvo.getSort());
                            ops.add(studentOptionVO);
                        }
                        examProVo.setOps(ops);

                        voNewList.add(examProVo);
                    }
                }

                if (voNewList != null && voNewList.size() > 0) {
                    voList.addAll(voNewList);
                }
            }
        }

        ExamResultVO erVo = new ExamResultVO();

        //后台job定时提交成功后发送消息需要企业,站点id,从考试信息中拿
        erVo.setAccountId(vo.getAccountId());
        erVo.setCompanyId(vo.getCompanyId());
        erVo.setSiteId(vo.getSiteId());
        erVo.setOrgId(vo.getOrgId());

        BigDecimal totalScore = BigDecimal.ZERO;

        // 保存考试
        boolean saveExamAnswer = saveExamAnswer(vo);
        LOGGER.info("examId = {},accountId = {},accountName = {},保存考试结果: {}",vo.getExamId(),vo.getAccountId(),vo.getAccountName(),saveExamAnswer);
        // 统计分数
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("answer_id", vo.getAnswerId());
        List<TrExamAnswerQuestion> list = this.selectByMap(map);
        List<TrExamAnswerQuestion> update = new ArrayList<>();
        List<TrExamAnswerQuestionRes> selectByMap = null;
        TrQuestionLibrarySubject ls = null;
        TrExamQuestion trExamQuestion = null;

        boolean isStudentrightAnswer = false;
        for (TrExamAnswerQuestion aq : list) {
            int answer = 0; // 学员回答正确答案
            int rightAnswer = 0; // 正确答案
            isStudentrightAnswer = false;
            ls = trQuestionLibrarySubjectService.selectById(aq.getSubjectId());
            if (null == ls) {
                continue;
            }
            if (ls.getType().compareTo(ExamConstant.FOUR) == 0) { // 主观题
                erVo.setIsres(1);
                continue;
            } else { // 客观题
                //判断选项是否选择了正确答案
                map.put("answer_question_id", aq.getId());
                selectByMap = trExamAnswerQuestionResService.selectByMap(map);
                if (!CollectionUtils.isEmpty(selectByMap)) {
                    for (TrExamAnswerQuestionRes res : selectByMap) {
					/*//统计正确答案数量
					if (res.getRightAnswer() == 1) {
						rightAnswer++;
					}
					//统计学员作答正确的答案数量
					if (res.getAnswer() == 1 && res.getAnswer() == res.getRightAnswer()) {
						answer++;
					}*/
                        //判断学员是否作答
                        if (res.getAnswer().compareTo(1) == 0) {
                            //判断学员作答是否正确答案
                            if (res.getRightAnswer().compareTo(1) == 0) {
                                isStudentrightAnswer = true;
                            } else {
                                isStudentrightAnswer = false;
                                break;
                            }
                        } else {
                            //判断没作答的选项是否正确答案
                            if (res.getRightAnswer().compareTo(1) == 0) {
                                isStudentrightAnswer = false;
                                break;
                            }
                        }
                    }
                }
            }
            if (isStudentrightAnswer) { // 学员答案正确，得分

                aq.setScore(scoreMap.get(aq.getSubjectId()));
                if (aq.getScore() != null) {
                    totalScore = totalScore.add(aq.getScore());

                    update.add(aq);
                }
            }
			/*if (answer > 0 && rightAnswer > 0 && answer == rightAnswer) { // 学员答案正确，得分
				trExamQuestion = iTrExamQuestionService.selectById(aq.getExamQuestionId());
				aq.setScore(trExamQuestion.getScore());
				if (aq.getScore() != null) {
					totalScore = totalScore.add(aq.getScore());
				}
				update.add(aq);
			} *//*
             * else{ // 学员答案错误 aq.setScore(BigDecimal.ZERO);
             * updateScoreList.add(aq); }
             */
        }
        if (update.size() > 0) {
            this.updateBatchById(update);
        }

        Exam exam = examService.selectById(vo.getExamId());
        // 考试历史（已提交和已阅卷）
        List<ExamHistoryVO> hisList = trExamAnswerService.selectExamHisList(vo.getAccountId(), exam.getId());
        for (ExamHistoryVO item : hisList) {
            Integer qualifiedScore = exam.getQualifiedScore();
            qualifiedScore = qualifiedScore == null ? 0 : qualifiedScore;
            item.setQualifiedScore(new BigDecimal(qualifiedScore));
            if (item.getState() == 1) {
                item.setState(0);
            } else if (item.getState() == 2) {
                if (item.getScore().compareTo(item.getQualifiedScore()) >= 0) {
                    item.setState(2);
                } else {
                    item.setState(1);
                }
            }
        }
        Integer examNum = 0;
        if (hisList != null) {
            examNum = hisList.size();
        }
        erVo.setExamNum(examNum);

        // 获取所有考试数据
        List<Long> allList = trExamAnswerMapper.getAnswerIdByAccountId(vo.getAccountId(), exam.getId());
        if (allList == null) {
            erVo.setExamNumAll(0);
        } else {
            erVo.setExamNumAll(allList.size());
        }

        erVo.setStartTime(exam.getStartTime());
        erVo.setEndTime(exam.getEndTime());

        erVo.setExamId(exam.getId());
        erVo.setRemark(null);
        totalScore = totalScore.setScale(1, BigDecimal.ROUND_HALF_UP);
        erVo.setScore(totalScore);
        erVo.setExamName(exam.getName());
        erVo.setHisList(hisList);
        erVo.setScoreSuccess(exam.getQualifiedScore());
        erVo.setAnswerNum(exam.getAnswerNum());

        // 更新答卷提交时间：超时的按考试结束时间，单次答卷超时按设置的时间
        Long between = null;
        long dtime = exam.getDuration();
        TrExamAnswer ea = trExamAnswerService.selectById(vo.getAnswerId());
        //设置考试用时,判断提交的时间是否大于考试结束时间，是的话设置成考试结束时间
        if (submitTime.getTime() - exam.getEndTime().getTime() >= 0) {
            if (dtime == 0) {//答卷时长，0无限制时按考试的开始和结束时间统计
                between = (exam.getEndTime().getTime() - exam.getStartTime().getTime()) / 1000;
            } else {
                between = dtime * 60;
            }
            ea.setSubmitTime(exam.getEndTime());
        } else {
            between = (submitTime.getTime() - ea.getStartTime().getTime()) / 1000;
            if (dtime == 0) {
                //答卷时间不限，按实际提交时间
                ea.setSubmitTime(submitTime);
            } else {
                if (between > dtime * 60) {
                    //考试超时，按考试结束时间
                    between = dtime * 60;
                    ea.setSubmitTime(new Date(ea.getStartTime().getTime() + (between * 1000)));
                } else {
                    //没超时，按实际提交时间
                    ea.setSubmitTime(submitTime);
                }
            }
        }
        ea.setDuration(between.intValue());

        ea.setUpdateTime(submitTime);
        ea.setUpdateById(vo.getAccountId());
        //ea.setUpdateByName(vo.getAccountName());
        ea.setUpdateByName("");
        ea.setScore(totalScore);

        if (erVo.getIsres() == 0) {
            // 全部是客观题，设置成已阅卷
            ea.setState(2);
        } else {
            // 有主观题，设置成待阅卷
            ea.setState(1);
        }
        trExamAnswerService.updateById(ea);

        /*
         * //获取已参加的考试次数（已提交和已阅卷）,和上面的代码重复了 List<Long> answerIds =
         * trExamAnswerMapper.getAnswerDetailListInfo(vo.getAccountId(),
         * exam.getId()); if(answerIds != null){ examNum = answerIds.size(); }
         * erVo.setExamNum(examNum);
         */

        // 创建阅卷（主观和客观都创建阅卷）
        boolean isInsert = false;
        TrExamOnlineReadOver trExamOnlineReadOver = examOnlineReadOverMapper.getExamOnlineReadOverByExamAnswerId(vo.getAnswerId());
        if (trExamOnlineReadOver == null) {
            trExamOnlineReadOver = new TrExamOnlineReadOver();
            trExamOnlineReadOver.setReadOverId(idGenerator.generate());
            isInsert = true;
        }

        trExamOnlineReadOver.setExamId(vo.getExamId());
        trExamOnlineReadOver.setExamAnswerId(ea.getId());
        trExamOnlineReadOver.setObjectiveScore(totalScore);
        if (erVo.getIsres() == 0) {
            // 全部是客观题，设置成已阅卷
            trExamOnlineReadOver.setState(2);
        } else {
            // 有主观题，设置成待阅卷
            trExamOnlineReadOver.setState(1);
        }
        trExamOnlineReadOver.setSumScore(totalScore);
        trExamOnlineReadOver.setAccountId(ea.getAccountId());
        trExamOnlineReadOver.setCreateById(vo.getAccountId());
        //trExamOnlineReadOver.setCreateByName(vo.getAccountName());
        trExamOnlineReadOver.setCreateByName("");
        trExamOnlineReadOver.setCreateTime(submitTime);
        trExamOnlineReadOver.setUpdateById(vo.getAccountId());
        //trExamOnlineReadOver.setUpdateByName(vo.getAccountName());
        trExamOnlineReadOver.setUpdateByName("");
        trExamOnlineReadOver.setUpdateTime(submitTime);
        trExamOnlineReadOver.setCompanyId(vo.getCompanyId());
        trExamOnlineReadOver.setOrgId(vo.getOrgId());
        trExamOnlineReadOver.setSiteId(vo.getSiteId());
        trExamOnlineReadOver.setReadType(erVo.getIsres());
        if (isInsert) {
            iTrExamOnlineReadOverService.insert(trExamOnlineReadOver);
        } else {
            iTrExamOnlineReadOverService.updateById(trExamOnlineReadOver);
        }

        if (erVo.getIsres() == 0 && exam.getIsPoint() == 1) {
            // 计算考试积分
            List<TrExamPointVO> trExamPointVOS = iTrExamPointService.listTrExamPoint(vo.getExamId());
            for (TrExamPointVO trExamPointVO : trExamPointVOS) {
                BigDecimal minScore = new BigDecimal(trExamPointVO.getMinScore());
                BigDecimal maxScore = new BigDecimal(trExamPointVO.getMaxScore());
                // a = -1,表示bigdemical小于bigdemical2；a = 0
                // 表示bigdemical等于bigdemical2；a = 1表示bigdemical大于bigdemical2；
                Integer a = totalScore.compareTo(minScore);
                Integer b = totalScore.compareTo(maxScore);
                if (a >= 0 && b < 1) {
                    if (erVo.getPoint() != null) {
                        if (erVo.getPoint() < trExamPointVO.getPoint()) {
                            erVo.setPoint(trExamPointVO.getPoint());
                        }
                    } else {
                        erVo.setPoint(trExamPointVO.getPoint());
                    }
                }
            }
        }

        // 清空考试缓存信息
        try {
            studentExamPaperService.clearStudentExam(vo.getAccountId(), vo.getExamId());
        } catch (Exception e) {
            e.printStackTrace();
        }

        //判断考试是否结束
        boolean examEnd = false;
        Date curDate = new Date();

        Long end = exam.getEndTime().getTime() - curDate.getTime();
        if (end <= 0) {
            examEnd = true;
        }
        // 判断是否显示分数评价
        Integer isPaperid = exam.getIsPaperid();
        if (null == isPaperid || isPaperid == 0 || erVo.getIsres() == 1) {
            erVo.setRemark("");
        } else {
            boolean isShowRemark = false;
            if (isPaperid == 1) {//交卷后显示
                isShowRemark = true;
            } else if (isPaperid == 2 && examEnd) {//考试结束后显示
                isShowRemark = true;
            }
            if (isShowRemark) {
                String remark = "";
                List<TrExamScoreEvaluateVO> markList = iTrExamScoreEvaluateService.listTrExamScoreEvaluate(vo.getExamId());
                Integer score = totalScore.toBigInteger().intValue();
                for (TrExamScoreEvaluateVO item : markList) {
                    if (score >= item.getMinScore() && score <= item.getMaxScore()) {
                        remark = item.getDescription();
                        break;
                    }
                }
                erVo.setRemark(remark);
            } else {
                erVo.setRemark("");
            }
        }

        // 判断是否显示查看答案
        Integer isAnswerPaper = exam.getIsAnswerPaper();
        if (null == isAnswerPaper || isAnswerPaper == 0) {//不显示
            erVo.setIsLookAnswer(0);
        } else if (isAnswerPaper == 1) {//交卷后显示
            erVo.setIsLookAnswer(1);
        } else if (isAnswerPaper == 2) {//考试结束后显示
            if (examEnd) {
                erVo.setIsLookAnswer(1);
            } else {
                erVo.setIsLookAnswer(2);
            }
        }
        // 判断是否显示成绩
        Integer isScore = exam.getIsScore();
        if (null == isScore || isScore == 0) {//不显示
            erVo.setIsScore(0);
        } else if (isScore == 1) {//交卷后显示
            erVo.setIsScore(1);
        } else if (isScore == 2) {//考试结束后显示
            if (examEnd) {
                erVo.setIsScore(1);
            } else {
                erVo.setIsScore(2);
            }
        }

        return erVo;
    }


    /**
     * 交卷 统计分数, 如果有主观题，不返回
     *
     * @param aswerId
     * @param boo     true 为交卷， false为审卷后计算总分
     * @return
     */
    private BigDecimal countScore(Long aswerId, boolean boo) {
        BigDecimal totalScore = BigDecimal.ZERO;
        //统计分数
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("answer_id", aswerId);
        List<TrExamAnswerQuestion> list = this.selectByMap(map);

        List<TrExamAnswerQuestion> updateScoreList = new ArrayList<TrExamAnswerQuestion>();

        for (TrExamAnswerQuestion aq : list) {
            TrQuestionLibrarySubject ls = trQuestionLibrarySubjectService.selectById(aq.getSubjectId());
            int answer = 0;
            int rightAnswer = 0;
            if (ls.getType().equals(ExamConstant.FOUR)) {  // 主观题
                if (boo) {  //交卷
                    return BigDecimal.ZERO;
                } else {   //审卷后计算总分
                    totalScore = totalScore.add(aq.getScore());
                }
            } else {    // 客观题
                Map<String, Object> map1 = new HashMap<String, Object>();
                map1.put("answer_id", aswerId);
                List<TrExamAnswerQuestionRes> selectByMap = trExamAnswerQuestionResService.selectByMap(map1);
                for (TrExamAnswerQuestionRes res : selectByMap) {
                    if (res.getRightAnswer() == 1) {
                        rightAnswer = rightAnswer++;
                    }
                    if (res.getAnswer().equals(res.getRightAnswer())) {
                        answer = answer++;
                    }
                }
            }
            if (answer == rightAnswer) {   // 学员答案正确
                totalScore = totalScore.add(aq.getScore());
            } else {     // 学员答案错误
                aq.setScore(BigDecimal.ZERO);
            }
        }
        if (updateScoreList.size() > 0) {
            this.updateBatchById(updateScoreList);
        }
        return totalScore;
    }

    @Override
    public boolean mark(ExamAnswerVO examAnswerVO) {
        TrExamAnswerQuestion trExamAnswerQuestion = new TrExamAnswerQuestion();
        trExamAnswerQuestion.setId(examAnswerVO.getId());
        trExamAnswerQuestion.setMark(examAnswerVO.getMark());
        trExamAnswerQuestion.setUpdateTime(new Date());
        trExamAnswerQuestion.setUpdateById(examAnswerVO.getAccountId());
        //trExamAnswerQuestion.setUpdateByName(examAnswerVO.getAccountName());
        trExamAnswerQuestion.setUpdateByName("");
        return this.updateById(trExamAnswerQuestion);
    }

    @Override
    public Map<Long, Map<String, String>> selectMark(Long answerId) {
        return trExamAnswerMapper.selectAnswerMark(answerId);
    }

    @Override
    public List<QuestionListVO> selectAnswerQuestion(Long answerId, Long accountId) {
        return null;
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRED)
    public ExamResultVO submitExamLose(ExamAnswerVO vo) {
        // 前端只提交作答的题库，未作答的不提交，这时要补全题目信息
        StudentExamPaperVO studentExamPaperVo = null;

        //查询缓存记录表，还原考试试卷
        ExamStudentAutoAnswerInfo answerInfo = examStudentAutoAnswerInfoMapper.selectById(vo.getAnswerId());
        if (answerInfo != null) {
            String content = answerInfo.getContent();
            if (!StringUtils.isBlank(content)) {
                studentExamPaperVo = JSON.toJavaObject(JSON.parseObject(content), StudentExamPaperVO.class);
            }
        }

        //没找到，在从库中还原考试试卷
        if (studentExamPaperVo == null) {
            LOGGER.error("缓存ExamStudentAutoAnswerInfo表中没有找到试卷;examId = {} ,answerId= {} ,accountId = {}",vo.getExamId(),vo.getAnswerId(),vo.getAccountId());
            return null;
        }

        vo.setExamId(studentExamPaperVo.getExamId());
        ExamResultVO erVo = saveAnswer(studentExamPaperVo, vo);
        return erVo;
    }

    @Override
    public List<CardVO> getMyExamAnswerCards(Long answerId) {

        List<CardVO> cardVOS = trExamAnswerQuestionMapper.getMyExamAnswerCards(answerId);
        if (!CollectionUtils.isEmpty(cardVOS)) {
            for (CardVO cardVO : cardVOS) {
                Integer sort = cardVO.getSort();
                Long index = Long.valueOf(sort);
                cardVO.setIndex(index);
            }
        }

        return cardVOS;
    }

}
