package com.yizhi.application.service.impl;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.application.domain.TrExamAnswer;
import com.yizhi.application.mapper.TrExamAnswerMapper;
import com.yizhi.application.service.ITrExamAnswerService;
import com.yizhi.exam.application.vo.AnswerDetailVO;
import com.yizhi.exam.application.vo.AnswerQuestionDetailVO;
import com.yizhi.exam.application.vo.AnswerQuestionListVO;
import com.yizhi.exam.application.vo.AnswerVO;
import com.yizhi.exam.application.vo.ExamAnswerByUserVO;
import com.yizhi.exam.application.vo.ExamAnswerVO;
import com.yizhi.exam.application.vo.dashboard.ExamDashboardQueryVO;
import com.yizhi.exam.application.vo.exam.AnswerTimeVO;
import com.yizhi.exam.application.vo.exam.ExamHistoryVO;
import com.yizhi.exam.application.vo.exam.StatisticalCountVO;
import com.yizhi.util.application.date.DateUtil;

/**
 * <p>
 * 答卷 服务实现类
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */

@Service
public class TrExamAnswerServiceImpl extends ServiceImpl<TrExamAnswerMapper, TrExamAnswer>
        implements ITrExamAnswerService {
    @Autowired
    private TrExamAnswerMapper trExamAnswerMapper;

    public Page<TrExamAnswer> getExamAnswerByExamId(Long examId, Integer pageNo, Integer pageSize, Long accountId,
                                                    Long orgId) {
        TrExamAnswer trExamAnswer = new TrExamAnswer();
        trExamAnswer.setAccountId(accountId);
        trExamAnswer.setExamId(examId);
        trExamAnswer.setOrgId(orgId);
        Page<TrExamAnswer> page = new Page<TrExamAnswer>(pageNo, pageSize, "create_time", false);
        EntityWrapper<TrExamAnswer> wrapper = new EntityWrapper<TrExamAnswer>(trExamAnswer);
        return this.selectPage(page, wrapper);
    }

    /**
     * 提交人数
     */
    public Integer getCommitNum(Long examId) {
        // TODO Auto-generated method stub
        TrExamAnswer trExamAnswer = new TrExamAnswer();
        trExamAnswer.setExamId(examId);
        trExamAnswer.setState(1);
        EntityWrapper<TrExamAnswer> wrapper = new EntityWrapper<TrExamAnswer>(trExamAnswer);
        return this.selectCount(wrapper);
    }

    public List<ExamAnswerVO> selectExamAnswerByExamId(List<Long> accountIdList, List<Long> orgIdList, Integer state, String tstart, String tend, Long examId, Integer pageNo, Integer pageSize) {
        Integer start = (pageNo - 1) * pageSize;
        Integer end = pageNo * pageSize;
        Date tstart1 = DateUtil.parse(tstart);
        Date tend1 = DateUtil.parse(tend);
        List<ExamAnswerVO> list = trExamAnswerMapper.selectExamAnswerByExamId(accountIdList, orgIdList, state, tstart1, tend1, examId, start, end);

        return list;
    }

    @Override
    public Integer selectTotal(List<Long> accountIdList, List<Long> orgIdList, Integer state, String tstart, String tend, Long examId) {
        Date tstart1 = DateUtil.parse(tstart);
        Date tend1 = DateUtil.parse(tend);
        Integer total = trExamAnswerMapper.selectTotal(accountIdList, orgIdList, state, tstart1, tend1, examId);
        return total;
    }


    public List<ExamAnswerVO> getExamAnswer(Long examId) {
        return trExamAnswerMapper.selectAnswer(examId);
    }

    /**
     * 获取考试历史数据(已提交和阅卷)
     */
    @Override
    public List<ExamHistoryVO> selectExamHisList(Long accountId, Long examId) {
        TrExamAnswer trExamAnswer = new TrExamAnswer();
        trExamAnswer.setAccountId(accountId);
        trExamAnswer.setExamId(examId);
        //trExamAnswer.setState(1);
        EntityWrapper<TrExamAnswer> wrapper = new EntityWrapper<TrExamAnswer>(trExamAnswer);
        List<TrExamAnswer> list = this.selectList(wrapper);
        List<ExamHistoryVO> examHistoryVOS = new ArrayList<ExamHistoryVO>();
        ExamHistoryVO examHistoryVO;
        for (TrExamAnswer trExamAnswer1 : list) {
            if (trExamAnswer1.getState() == 0) {
                continue;
            }
            examHistoryVO = new ExamHistoryVO();
            examHistoryVO.setId(trExamAnswer1.getId());
            examHistoryVO.setScore(trExamAnswer1.getScore());
            examHistoryVO.setSubmitTime(trExamAnswer1.getSubmitTime());
            examHistoryVO.setState(trExamAnswer1.getState());
            if (trExamAnswer1.getState().equals(2)) {
                examHistoryVO.setIsres(0);
            } else {
                examHistoryVO.setIsres(1);
            }
            examHistoryVOS.add(examHistoryVO);
        }
        return examHistoryVOS;
    }

    /**
     * 没有考试的人员id
     */
    public List<Long> noExamIdList(Long examId, List<Long> shouldListId) {
        // TODO Auto-generated method stub
        System.out.println(examId + "===" + shouldListId);
        return trExamAnswerMapper.noExamListId(examId, shouldListId);
    }

    /**
     * 根据考试ID和学员ID查看最后一次答卷信息
     */
    @Override
    public TrExamAnswer selectLastAnswer(Long examId, Long accountId) {
        TrExamAnswer trExamAnswer = new TrExamAnswer();
        trExamAnswer.setExamId(examId);
        trExamAnswer.setCreateById(accountId);
        EntityWrapper<TrExamAnswer> wapper = new EntityWrapper<TrExamAnswer>(trExamAnswer);
        wapper.orderBy("create_time", false);
        wapper.last("limit 1");
        return this.selectOne(wapper);
    }

    /**
     * 学员端查看考试结果列表
     */
    public List<TrExamAnswer> getExamAnswerListByExamIdAndAccountId(Long examId, Long accountId) {
        // TODO Auto-generated method stub
        TrExamAnswer trExamAnswer = new TrExamAnswer();
        trExamAnswer.setExamId(examId);
        trExamAnswer.setAccountId(accountId);
        EntityWrapper<TrExamAnswer> wrapper = new EntityWrapper<TrExamAnswer>(trExamAnswer);
        return this.selectList(wrapper);
    }

	/*@Override
	public List<ExamHistoryVO> selectExamHisList(Long aId, Integer qualifiedScore) {
		List<ExamHistoryVO> list = new ArrayList<ExamHistoryVO>();
		TrExamAnswer selectById = this.selectById(aId);
		Long accountId = selectById.getAccountId();
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("account_id", accountId);
		map.put("exam_id", selectById.getExamId());
		List<TrExamAnswer> selectByMap = this.selectByMap(map);
		for(TrExamAnswer ea : selectByMap){
			ExamHistoryVO vo = new ExamHistoryVO();
			vo.setStartTime(DateUtil.toSeconds(ea.getStartTime()));
			vo.setScore(ea.getScore());
			vo.setQualifiedScore(BigDecimal.valueOf(qualifiedScore));
			list.add(vo);
		}
		return list;
	}*/

    @Override
    public Integer selectMaxScore(Long accountId) {
        return trExamAnswerMapper.selectMaxScore(accountId);
    }

    @Override
    public Page<AnswerQuestionDetailVO> answerQuestionDetail(Long answerId, int pageNo, int pageSize) {
        Page<AnswerQuestionDetailVO> page = new Page<AnswerQuestionDetailVO>(pageNo, pageSize);
        List<AnswerQuestionDetailVO> list = trExamAnswerMapper.answerQuestionDetail(page, answerId);
        return page.setRecords(list);
    }

    @Override
    public AnswerTimeVO selectTime(Long examId, Long answerId) {
        return trExamAnswerMapper.selectTime(examId, answerId);
    }

    @Override
    public List<ExamHistoryVO> selectHistorys(Long examId, Long accountId) {
        return trExamAnswerMapper.selectExamHistory(examId, accountId);
    }

    /**
     * 根据考试ID查询交卷人数
     */
    @Override
    public int submitCount(Long examId) {
/*		TrExamAnswer trExamAnswer = new TrExamAnswer();
		trExamAnswer.setExamId(examId);
		trExamAnswer.setState(1);
		EntityWrapper<TrExamAnswer> entityWrapper = new EntityWrapper<>(trExamAnswer);
		return this.selectCount(entityWrapper);*/
        return trExamAnswerMapper.selectSubmitCount(examId);
    }

    @Override
    public Integer selectCountGroupByAccountId(Long companyId) {
        return trExamAnswerMapper.selectCountGroupByAccountId(companyId);
    }

    @Override
    public Integer selectByCount(Long examId) {
        return trExamAnswerMapper.selectByCount(examId);
    }

    @Override
    public StatisticalCountVO selectStaticalCount(Long examId) {
        return trExamAnswerMapper.selectStaticalCount(examId);
    }

    public AnswerDetailVO answerDetail(Long accountId, Integer time, Integer pageNo, Integer pageSize, Long examId) {
        Page<AnswerQuestionDetailVO> page = new Page<AnswerQuestionDetailVO>(pageNo, pageSize);
        //查询某个人该场考试的所有答卷id
        List<Long> answerIds = trExamAnswerMapper.getAnswerIdByAccountId(accountId, examId);
        Long answer = answerIds.get(time - 1);
        //查询考试的题目及题目选项
        List<AnswerQuestionDetailVO> list = trExamAnswerMapper.answerQuestionDetail(page, answer);
        page.setRecords(list);
        //查询该场考试的个人信息
        AnswerVO answerVO = trExamAnswerMapper.answerDetail(answer);
        answerVO.setAnswerId(answer);
        //组合成答卷
        AnswerDetailVO detailVO = new AnswerDetailVO();
        detailVO.setAnswerVO(answerVO);
        detailVO.setPage(page);
        return detailVO;
    }

    @Override
    public List<AnswerDetailVO> getAnswerDetailList(ExamAnswerByUserVO vo) {
        List<AnswerDetailVO> list = new ArrayList<AnswerDetailVO>();
        Page<AnswerQuestionDetailVO> page = new Page<AnswerQuestionDetailVO>(vo.getPageNo(), vo.getPageSize());
        //查询某个人该场考试的所有答卷id
        List<Long> answerIds = trExamAnswerMapper.getAnswerDetailListInfo(vo.getAccountId(), vo.getExamId());
        if (answerIds == null || answerIds.size() == 0) {
            return null;
        }
        AnswerDetailVO adVo = null;
        List<AnswerQuestionDetailVO> aqList = null;
        AnswerVO answerVO = null;
        for (Long id : answerIds) {
            //查询考试的题目及题目选项
            aqList = trExamAnswerMapper.answerQuestionDetail(page, id);
            page.setRecords(aqList);
            //查询该场考试的个人信息
            answerVO = trExamAnswerMapper.answerDetail(id);
            answerVO.setAnswerId(id);
            //组合成答卷
            adVo = new AnswerDetailVO();
            adVo.setAnswerVO(answerVO);
            adVo.setPage(page);
            list.add(adVo);
        }
        return list;
    }

    @Override
    public TrExamAnswer selectMaxScoreByAccountIdAndExamId(Long accountId, Long examId) {
        return trExamAnswerMapper.selectMaxScoreByAccountIdAndExamId(accountId, examId);
    }

    /**
     * 获取已参加的考试次数（已提交和已阅卷）
     */
    @Override
    public List<Long> getAnswerDetailListInfo(Long accountId, Long examId) {
        List<Long> answerIds = trExamAnswerMapper.getAnswerDetailListInfo(accountId, examId);
        return answerIds;
    }

    @Override
    public AnswerQuestionListVO answerMainQuestionDetailByAnswerQuestionId(Long answerQuestionId) {
        return trExamAnswerMapper.answerMainQuestionDetailByAnswerQuestionId(answerQuestionId);
    }

    @Override
    public List<TrExamAnswer> getUnSubmitExam(Long companyId) {
        return trExamAnswerMapper.getUnSubmitExam(companyId);
    }

    @Override
    public Integer getFullScore(Long examId, Long answerQuesionId) {
        return trExamAnswerMapper.getFullScore(examId, answerQuesionId);
    }

    @Override
    public List<TrExamAnswer> getEarlyPassExamIdByExamIds(List<Long> listIds) {
        // TODO Auto-generated method stub
        List<TrExamAnswer> list = trExamAnswerMapper.getEarlyPassExamIdByExamIds(listIds);
        if (CollectionUtils.isNotEmpty(list)) {
            DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (TrExamAnswer trExamAnswer : list) {
                Long examId = trExamAnswer.getExamId();
                Date date = trExamAnswer.getStartTime();
                String startTime = df.format(date);
                BigDecimal score = trExamAnswerMapper.getScoreByExamIdAndStartTime(examId, startTime);
                trExamAnswer.setScore(score);
            }
        }
        return list;
    }

    @Override
    public List<Long> getFinishedAccountIds(Long examId, Long companyId, Long siteId) {
        return trExamAnswerMapper.getFinishedAccountIds(examId, companyId, siteId);
    }

    @Override
    public Map<Long, Map<String, BigDecimal>> getQuestionFullScoreMap(Long answerId, Long examId) {
        return trExamAnswerMapper.getQuestionFullScoreMap(answerId, examId);
    }

    @Override
    public Map<Integer, Map<String, BigDecimal>> getSystemQuestionFullScoreMap(Long examId) {
        return trExamAnswerMapper.getSystemQuestionFullScoreMap(examId);
    }

	@Override
	public List<TrExamAnswer> getBySiteAndDateScope(Long siteId, Date from, Date to) {
		return trExamAnswerMapper.getBySiteAndDateScope(siteId, from, to);
	}

	@Override
	public Map<Long, Integer> getExamDashboardData(ExamDashboardQueryVO query) {
		List<TrExamAnswer> answers = getBySiteAndDateScope(query.getSiteId(), query.getStartDate(), query.getEndDate());
		
		if(CollectionUtils.isNotEmpty(answers)) {
			return answers.stream().collect(Collectors.groupingBy(TrExamAnswer::getAccountId
															, Collectors.summingInt(TrExamAnswer::getDuration)));
		}
		
		return null;
	}
}
