package com.yizhi.application.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.yizhi.application.constant.ExamConstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.application.domain.TrExamAuthorize;
import com.yizhi.exam.application.vo.TrExamAuthorizeVO;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.application.mapper.TrExamAuthorizeMapper;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.service.ITrExamAuthorizeService;
import org.springframework.util.CollectionUtils;

/**
 * <p>
 * 考试人员范围 服务实现类
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
@Service
public class TrExamAuthorizeServiceImpl extends ServiceImpl<TrExamAuthorizeMapper, TrExamAuthorize>
        implements ITrExamAuthorizeService {

    private Logger logger = LoggerFactory.getLogger(TrExamAuthorizeServiceImpl.class);

    @Autowired
    TrExamAuthorizeMapper trExamAuthorizeMapper;

    @Autowired
    private IdGenerator idGenerator;

    @Override
    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public List<TrExamAuthorizeVO> listTrExamAuthorize(Long examId) {
		/*List<TrExamAuthorizeVO> list = new ArrayList<TrExamAuthorizeVO>();
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("exam_id", examId);
		map.put("state", ExamConstant.FIRST);
		List<TrExamAuthorize> selectByMap = this.selectByMap(map);
		for (TrExamAuthorize ta : selectByMap) {
			TrExamAuthorizeVO vo = new TrExamAuthorizeVO();
			vo.setId(ta.getId());
			vo.setExamId(examId);
			vo.setRelationId(ta.getRelationId());
			vo.setType(ta.getType());
			vo.setState(ta.getState());
			list.add(vo);
		}*/
        return trExamAuthorizeMapper.listTrExamAuthorize(examId);
    }

    @Override
    public Boolean insertAllAuthorize(List<TrExamAuthorizeVO> trExamAuthorizeVOS, Long accountId, String accountName, Long siteId) {
        List<TrExamAuthorize> trExamAuthorizes = new ArrayList<>();
        Date createTime = new Date();
        TrExamAuthorize trExamAuthorize = new TrExamAuthorize();
        trExamAuthorize.setExamId(trExamAuthorizeVOS.get(0).getExamId());
        EntityWrapper<TrExamAuthorize> entityWrapper = new EntityWrapper<>(trExamAuthorize);
        trExamAuthorizeMapper.delete(entityWrapper);
        TrExamAuthorize obj;
        for (TrExamAuthorizeVO trExamAuthorizeVO : trExamAuthorizeVOS) {
            obj = new TrExamAuthorize();
            obj.setId(idGenerator.generate());
            obj.setExamId(trExamAuthorizeVO.getExamId());
            obj.setType(trExamAuthorizeVO.getType());
            obj.setName(trExamAuthorizeVO.getName());
            obj.setRelationId(trExamAuthorizeVO.getRelationId());
            obj.setCreateById(accountId);
            obj.setCreateByName(accountName);
            obj.setCreateTime(createTime);
            obj.setUpdateById(accountId);
            obj.setUpdateByName(accountName);
            obj.setUpdateTime(createTime);
            obj.setSiteId(siteId);
            trExamAuthorizes.add(obj);
        }
        return this.insertBatch(trExamAuthorizes);
    }

    /**
     * 根据考试ID查询考试人员范围列表
     */
    @Override
    public List<TrExamAuthorize> examCount(Long examId) {
        TrExamAuthorize trExamAuthorize = new TrExamAuthorize();
        trExamAuthorize.setExamId(examId);
        trExamAuthorize.setState(1);
        EntityWrapper<TrExamAuthorize> wrapper = new EntityWrapper<TrExamAuthorize>(trExamAuthorize);
        return this.selectList(wrapper);
    }

    @Override
    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public boolean updateTrExamAuthorizeList(List<TrExamAuthorizeVO> trExamAuthorizeVoList, Long examId) {
        List<TrExamAuthorize> list = new ArrayList<TrExamAuthorize>();
        List<TrExamAuthorize> updateList = new ArrayList<TrExamAuthorize>();
        TrExamAuthorize tea = null;
        for (TrExamAuthorizeVO vo : trExamAuthorizeVoList) {
            tea = new TrExamAuthorize();
            if (vo.getId() == null) {
                tea.setId(idGenerator.generate());
                tea.setExamId(examId);
                tea.setType(vo.getType());
                tea.setRelationId(vo.getRelationId());
                tea.setName(vo.getName());
                tea.setState(ExamConstant.FIRST);
                setInsertCloumn(tea, true);
                list.add(tea);
            } else {
                tea = this.selectById(vo.getId());
                if (null != tea) {
                    tea.setType(vo.getType());
                    tea.setRelationId(vo.getRelationId());
                    tea.setState(vo.getState());
                    tea.setName(vo.getName());
                    setInsertCloumn(tea, false);
                    updateList.add(tea);
                }
            }
        }
        if (list.size() > 0) {
            this.insertBatch(list);
        }
        if (updateList.size() > 0) {
            this.updateBatchById(updateList);
        }
        return true;
    }

    @Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
    public boolean copyTrExamAuthorize(Long oldExamId, Long examId) {
        List<TrExamAuthorize> list = new ArrayList<TrExamAuthorize>();
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("exam_id", oldExamId);
        map.put("state", ExamConstant.FIRST);
        List<TrExamAuthorize> selectByMap = this.selectByMap(map);
        TrExamAuthorize tq = null;
        for (TrExamAuthorize tea : selectByMap) {
            tq = new TrExamAuthorize();
            BeanUtils.copyProperties(tea, tq);
            tq.setId(idGenerator.generate());
            tq.setExamId(examId);
            setInsertCloumn(tq, true);
            list.add(tq);
        }
        if (list.size() > 0) {
            this.insertBatch(list);
        }
        return true;
    }

    public void setInsertCloumn(TrExamAuthorize tq, boolean boo) {
        Long accountId = null;
        String accountName = null;
        RequestContext requestContext = ContextHolder.get();
        if (null != requestContext) {
            if (null != requestContext.getAccountId()) {
                accountId = requestContext.getAccountId();
            }
            if (null != requestContext.getAccountName()) {
                accountName = requestContext.getAccountName();
            }
        }
        accountId = 9999L;
        accountName = "bob";

        if (boo) { // 新增
            tq.setCreateById(accountId);
            tq.setCreateByName(accountName);
            tq.setCreateTime(new Date());
            tq.setUpdateById(accountId);
            tq.setUpdateByName(accountName);
            tq.setUpdateTime(new Date());
        } else { // 修改
            tq.setUpdateById(accountId);
            tq.setUpdateByName(accountName);
            tq.setUpdateTime(new Date());
        }
    }


    /**
     * 应该考试的人数
     */
    @Override
    public Integer getShouldExamNum(Long examId) {
        // TODO Auto-generated method stub
        TrExamAuthorize trExamAuthorize = new TrExamAuthorize();
        trExamAuthorize.setExamId(examId);
        trExamAuthorize.setState(1);
        EntityWrapper<TrExamAuthorize> wrapper = new EntityWrapper<TrExamAuthorize>(trExamAuthorize);
        return this.selectCount(wrapper);
    }

    @Override
    public Page<TrExamAuthorize> listId(Long examId, Integer pageSize, Integer pageNo) {
        // TODO Auto-generated method stub

        Page<TrExamAuthorize> page = new Page<TrExamAuthorize>(pageNo, pageSize, "exam_Id", true);
        TrExamAuthorize trExamAuthorize = new TrExamAuthorize();

        trExamAuthorize.setExamId(examId);
        EntityWrapper<TrExamAuthorize> wrapper = new EntityWrapper<TrExamAuthorize>(trExamAuthorize);
        return this.selectPage(page, wrapper);
    }

    /**
     * 应该考试的人员id
     */
    @Override
    public List<Long> examIdList(Long examId) {
        // TODO Auto-generated method stub
        return trExamAuthorizeMapper.selectRelationidByExamid(examId);
    }

    @Override
    @Transactional
    public boolean insertAll(List<TrExamAuthorize> trExamAuthorizes) {
        if (!CollectionUtils.isEmpty(trExamAuthorizes)) {
            Long examId = trExamAuthorizes.get(0).getExamId();
            TrExamAuthorize trExamAuthorize = new TrExamAuthorize();
            trExamAuthorize.setState(1);
            trExamAuthorize.setExamId(examId);
            EntityWrapper<TrExamAuthorize> entityWrapper = new EntityWrapper<>(trExamAuthorize);
            this.delete(entityWrapper);
            for (TrExamAuthorize trExamAuthorize1 : trExamAuthorizes) {
                trExamAuthorize1.setId(idGenerator.generate());
            }
            return this.insertBatch(trExamAuthorizes);
        } else {
            logger.error("列表为空 ");
            return Boolean.FALSE;
        }
    }

}
