package com.yizhi.application.repository;

import com.yizhi.application.domain.PointDetails;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

/**
 * @Date 2021/2/4 4:04 下午
 * @Author lvjianhui
 **/
@Repository
public interface PointDetailsRepository extends JpaRepository<PointDetails,Long> {

    @Modifying
    @Transactional
    @Query(value = "UPDATE point_details c\n" +
            "        LEFT JOIN (\n" +
            "            SELECT\n" +
            "                d1.id AS id,\n" +
            "                sum( d2.point ) AS sum_of_point\n" +
            "            FROM\n" +
            "                point_details d1\n" +
            "                LEFT JOIN point_details d2 ON d1.account_id = d2.account_id\n" +
            "                AND d1.site_id = d2.site_id\n" +
            "                AND d1.company_id = d2.company_id\n" +
            "            WHERE\n" +
            "                d1.id >= d2.id\n" +
            "                AND d1.site_id = ?1\n" +
            "                AND d1.account_id = ?2\n" +
            "            GROUP BY\n" +
            "                d1.account_id,\n" +
            "                d1.company_id,\n" +
            "                d1.id\n" +
            "            ) AS d\n" +
            "            ON c.id = d.id\n" +
            "            set c.change_after = d.sum_of_point\n" +
            "        WHERE\n" +
            "            c.site_id = ?1\n" +
            "            and\n" +
            "            c.account_id = ?2",nativeQuery = true)
    public void updatePoint(Long siteId,Long accountId);

}
