package com.yizhi.application.service.impl;

import java.util.List;

import com.yizhi.application.mapper.PointLevelMapper;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.service.PointLevelService;
import com.yizhi.application.domain.PointLevel;
import com.yizhi.core.application.context.ContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;

/**
 * <p>
 * 积分等级 服务实现类
 * </p>
 *
 * @author bob123
 * @since 2018-04-20
 */
@Service
public class PointLevelServiceImpl extends ServiceImpl<PointLevelMapper, PointLevel> implements PointLevelService {
	
	@Autowired
	IdGenerator idGenerator ;
	@Autowired
	PointLevelMapper pointLevelMapper;
	
	@Override
	public Boolean inserts(PointLevel pointLevel) {
		Long companyId = ContextHolder.get().getCompanyId();
		Long orgId = ContextHolder.get().getOrgId();
		Long siteId = ContextHolder.get().getSiteId();
		pointLevel.setId(idGenerator.generate());
		pointLevel.setCompanyId(companyId);
		pointLevel.setOrgId(orgId);
		pointLevel.setSiteId(siteId);
		return pointLevelMapper.insert(pointLevel)>0;
	}

	@Override
	public Boolean piontLevelDelete(Long id) {
		
		return pointLevelMapper.piontLevelDelete(id);
	}

	@Override
	public List<PointLevel> levelList(Long id) {
		
		return pointLevelMapper.levelList(id);
	}

	@Override
	public Integer updateById1(PointLevel pointLevel) {
		
		return pointLevelMapper.updateById(pointLevel);
	}
}
