package com.yizhi.application.service.impl;

import java.util.Date;

import com.yizhi.application.orm.id.IdGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.application.domain.Point;
import com.yizhi.application.mapper.PointMapper;
import com.yizhi.application.service.PointService;

/**
 * <p>
 * 积分设置 服务实现类
 * </p>
 *
 * @author bob123
 * @since 2018-04-20
 */
@Service
public class PointServiceImpl extends ServiceImpl<PointMapper, Point> implements PointService {
	
	@Autowired
	PointMapper pointMapper;
	
	@Autowired
	IdGenerator idGenerator;
	 
	@Override
	public Point pointList(Long companyId, Long siteId) {
		Point point = pointMapper.pointList(companyId, siteId);
		if(point == null){
			point = new Point();
			point.setState(0);
			point.setUnit("积分");
		}
		return point;
	}

	@Override
	public boolean updateList(Point point) {
		Integer state = point.getState(); 
		String unit = point.getUnit();
		Long companyId = point.getCompanyId();
		Long siteId = point.getSiteId();
		Long updateAccountId = point.getUpdateById();
		String updateAccountName = point.getUpdateByName();
		Integer count = pointMapper.updateList(state, unit, companyId, siteId, updateAccountId, updateAccountName);
		if(count > 0){
			return true;
		} else {
			point.setId(idGenerator.generate());
			point.setCreateById(updateAccountId);
			point.setCreateByName(updateAccountName);
			point.setCreateTime(new Date());
			count = pointMapper.insert(point);
			if(count > 0){
				return true;
			}
		}
		
		return false;
	}

}
