package com.yizhi.application.controller;

import com.yizhi.application.domain.MqPointParam;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.redis.RedisUtils;
import com.yizhi.application.service.MqPointParamService;
import com.yizhi.point.application.vo.PointParamVO;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;


@RestController
public class PointRedisController {
	
	@Autowired
	RedisUtils redisUtils;
	@Autowired
	private IdGenerator idGenerator;
	@Autowired
	private MqPointParamService mqPointParamService;

	@PostMapping("/point/redis/add")
	public String addPointRedis(@RequestBody PointParamVO vo) {
		String key = idGenerator.generate().toString();
		vo.setId(key);
		boolean boo = redisUtils.set(key, vo, 10800L);
		if(boo){
			MqPointParam mqPointParam = new MqPointParam();
			BeanUtils.copyProperties(vo, mqPointParam);
			mqPointParam.setState(1);
			mqPointParamService.insert(mqPointParam);
			return key;
		}
		return null;
	}

}
