package com.yizhi.point.application.feign;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.point.application.vo.PointDetailListVO;
import com.yizhi.point.application.vo.PointSearchParamVO;
import com.yizhi.point.application.vo.domain.PointProductVo;
import com.yizhi.point.application.vo.domain.PointVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 积分设置
 * 
 * @author HUIHUI.DUAN
 * @date 2018/3/28 10:44
 */
@FeignClient(name = "point", contextId = "PointApiFeignClients")
public interface PointApiFeignClients {

	@GetMapping("/api/point/exchange")
    boolean exchange(
            @RequestParam(name = "companyId" ,required = false ) Long companyId,
            @RequestParam(name = "orgId" ,required = false ) Long orgId,
            @RequestParam(name = "siteId" ,required = false ) Long siteId,
            @RequestParam(name = "accountId" ,required = false ) Long accountId,
            @RequestParam(name = "accountName" ,required = false ) String accountName,
            @RequestParam(name = "productIds" ,required = false ) String productIds);

    @GetMapping("/api/point/list")
    List<PointDetailListVO> list(@RequestParam(name = "accountId" ,required = false ) Long accountId,
                                        @RequestParam(name = "pageNo" ,required = false ) Integer pageNo,
                                        @RequestParam(name = "pageSize" ,required = false ) Integer pageSize);

    @GetMapping("/api/point/product/list")
    List<PointProductVo> productList(@RequestParam(name = "pageNo" ,required = false ) Integer pageNo,
                                     @RequestParam(name = "pageSize" ,required = false ) Integer pageSize);

    @GetMapping("/api/point/read/finished")
    boolean readFinished(
            @RequestParam(name = "accountId" ,required = false ) Long accountId,
            @RequestParam(name = "infoId" ,required = false ) String infoId);

    @GetMapping("/addPoint")
    boolean addPoint(
            @RequestParam(name = "accountId" ,required = false ) Long accountId,
            @RequestParam(name = "type" ,required = false ) String type,
            @RequestParam(name = "sourceId" ,required = false ) String sourceId);
}
