package com.yizhi.point.application.feign;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.point.application.vo.PointSearchParamVO;
import com.yizhi.point.application.vo.domain.MqPointParamVo;
import com.yizhi.point.application.vo.domain.PointActivityVo;
import com.yizhi.point.application.vo.domain.PointProductVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * 轮播
 *
 * @author HUIHUI.DUAN
 * @date 2018/3/28 10:44
 */
@FeignClient(name = "point", contextId = "PointProductFeignClients")
public interface PointProductFeignClients {

    @PostMapping("/manage/point/product/insert")
    Long insertDetail(@RequestBody PointProductVo pointProductVo);

    @PostMapping("/manage/point/product/delete")
    Long deleteDetailById(@RequestBody PointProductVo pointProductVo);

    @PostMapping("/manage/point/product/update")
    Long updateById(@RequestBody PointProductVo pointProductVo);

    @PostMapping("/manage/point/product/enabled")
    Boolean pointUp(@RequestBody PointProductVo pointProductVo);

    @PostMapping("/manage/point/product/disabled")
    Boolean pointDown(@RequestBody PointProductVo pointProductVo);

    @GetMapping("/manage/point/product/list")
    Page<PointProductVo> productList(@RequestBody PointSearchParamVO searchParamVO);
}
