package com.yizhi.point.application.vo.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 积分等级
 * </p>
 *
 * @author bob123
 * @since 2018-04-20
 */
@Data
@ApiModel(value = "PointLevelVo", description = "积分等级")
@TableName("point_level")
public class PointLevelVo extends Model<PointLevelVo> {

    private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "积分等级ID")
    private Long id;

	@ApiModelProperty(value = "等级序号")
    @TableField("level_no")
    private Integer levelNo;

	@ApiModelProperty(value = "等级名称")
    @TableField("level_name")
    private String levelName;

	@ApiModelProperty(value = "分值区间开始")
    @TableField("start_score")
    private Integer startScore;

	@ApiModelProperty(value = "分值区间结束")
    @TableField("end_score")
    private Integer endScore;

	@ApiModelProperty(value = "状态 0删除 1有效")
    private Integer state;

	@ApiModelProperty(value = "创建时间")
    @TableField("create_time")
    private Date createTime;

	@ApiModelProperty(value = "创建人")
    @TableField("create_by_id")
    private Long createById;

	@ApiModelProperty(value = "创建人姓名")
    @TableField("create_by_name")
    private String createByName;

	@ApiModelProperty(value = "修改时间")
    @TableField("update_time")
    private Date updateTime;

	@ApiModelProperty(value = "修改人")
    @TableField("update_by_id")
    private Long updateById;

	@ApiModelProperty(value = "修改人姓名")
    @TableField("update_by_name")
    private String updateByName;

	@ApiModelProperty(value = "公司ID")
    @TableField("company_id")
    private Long companyId;

	@ApiModelProperty(value = "部门ID")
    @TableField("org_id")
    private Long orgId;

	@ApiModelProperty(value = "站点ID")
    @TableField("site_id")
    private Long siteId;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }
}
