package com.yizhi.point.application.vo;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * <p>
 * 积分明细
 * </p>
 *
 * @author bob123
 * @since 2018-04-20
 */
@Data
@ApiModel(value = "PointDetailsVO", description = "积分详情")
public class PointDetailsVO{

    @ApiModelProperty(value = "积分明细id")
    private String id;
 
	@ApiModelProperty(value = "时间")
    private Date time;

	@ApiModelProperty(value = "积分")
    private Integer point;

	@ApiModelProperty(value = "积分正负标识：0减  1加") 
    private Integer flag;

	@ApiModelProperty(value = "学习活动类型")
    @TableField("learn_type")
    private String learnType;

	@ApiModelProperty(value = "学习活动名称")
    @TableField("learn_name")
    private String learnName;

	@ApiModelProperty(value = "学习活动来源")
    @TableField("learn_source")
    private String learnSource;

	@ApiModelProperty(value = "月份")
    private String month;
	
	@ApiModelProperty(value = "学员")
    private String accountId;
	
	@ApiModelProperty(value = "学员姓名")
    private String accountName;

    @ApiModelProperty(value = "当前积分的总量")
    private String amount;

    @ApiModelProperty(value = "变动原因")
    private String changeReason;

    @ApiModelProperty(value = "变动前积分总量")
    private Integer changeBefore;

    @ApiModelProperty(value = "变动后积分总量")
    private Integer changeAfter;

    @ApiModelProperty(value = "公司ID")
    @TableField("company_id")
    private Long companyId;

    @ApiModelProperty(value = "部门ID")
    @TableField("org_id")
    private Long orgId;

    @ApiModelProperty(value = "站点ID")
    @TableField("site_id")
    private Long siteId;



}
