package com.yizhi.point.application.feign;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.point.application.vo.PointDetailsVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name = "point", contextId = "PointManageFeignClients")
public interface PointManageFeignClients {
	@GetMapping("/manage/point/details/list")
	Page<PointDetailsVO> getManagePointDetails(
			@RequestParam(name = "learnType", required = false) String learnType,
			@RequestParam(name = "accountName", required = false) String accountName, 
			@RequestParam(name = "startTime", required = false) Long startTime, @RequestParam(name = "endTime", required = false) Long endTime,
			@RequestParam(name = "pageNo", required = false) Integer pageNo, @RequestParam(name = "pageSize", required = false) Integer pageSize, 
			@RequestParam(name = "companyId", required = false) Long companyId, @RequestParam(name = "siteId", required = false) Long siteId);


	@GetMapping("/manage/point/update/after")
	public void updatePointDetailsChangeAfter(
			@RequestParam(name = "siteId" ,required = false ) Long siteId,
			@RequestParam(name = "accountId" ,required = false ) Long accountId);
}
