package com.yizhi.application.controller;


import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.domain.Point;
import com.yizhi.application.service.PointDetailsService;
import com.yizhi.application.service.PointProductService;
import com.yizhi.application.service.PointService;
import com.yizhi.application.service.PointUserService;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.point.application.vo.PointDetailListVO;
import com.yizhi.point.application.vo.PointDetailsVO;
import com.yizhi.point.application.vo.domain.PointProductVo;
import com.yizhi.point.application.vo.domain.PointVo;
import com.yizhi.system.application.system.remote.AccountClient;
import com.yizhi.system.application.vo.AccountVO;
import io.swagger.annotations.Api;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 积分设置 前端控制器
 * </p>
 *
 * @author bob123
 * @since 2018-04-20
 */
@Api(tags="积分商城", description="积分商城")
@RestController
@RequestMapping("/api/point")
public class PointApiController {
	
	private static final Logger LOG = LoggerFactory.getLogger(PointApiController.class);
	
	@Autowired
	PointService pointService;
	@Autowired
	PointProductService pointProductService;

	@GetMapping("/list")
	public List<PointDetailListVO> list(@RequestParam(name = "accountId" ,required = false ) Long accountId,
										@RequestParam(name = "pageNo" ,required = false ) Integer pageNo,
										@RequestParam(name = "pageSize" ,required = false ) Integer pageSize){
		Page<PointDetailListVO> page = pointService.getPointDetailsList(accountId, pageNo, pageSize);
		return page.getRecords();
	}

	@GetMapping("/product/list")
	public List<PointProductVo> productList(
										@RequestParam(name = "pageNo" ,required = false ) Integer pageNo,
										@RequestParam(name = "pageSize" ,required = false ) Integer pageSize){
		return pointProductService.productListExchange(pageNo, pageSize);
	}

	@GetMapping("/exchange")
	public boolean exchange(
			@RequestParam(name = "companyId" ,required = false ) Long companyId,
			@RequestParam(name = "orgId" ,required = false ) Long orgId,
			@RequestParam(name = "siteId" ,required = false ) Long siteId,
			@RequestParam(name = "accountId" ,required = false ) Long accountId,
			@RequestParam(name = "accountName" ,required = false ) String accountName,
			@RequestParam(name = "productIds" ,required = false ) String productIds) {
		return pointService.exchange(companyId, orgId, siteId, accountId, accountName, productIds);
	}

	@GetMapping("/read/finished")
	public boolean finished(
			@RequestParam(name = "accountId" ,required = false ) Long accountId,
			@RequestParam(name = "infoId" ,required = false ) String infoId){
		pointService.addPoint(accountId, "point_read", infoId);
		return true;
	}
}

