package com.yizhi.application.controller;


import java.util.ArrayList;
import java.util.List;

import com.yizhi.application.domain.PointLevel;
import com.yizhi.application.service.PointLevelService;
import com.yizhi.point.application.vo.domain.PointLevelVo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import io.swagger.annotations.Api;

/**
 * <p>
 * 积分等级 前端控制器
 * </p>
 *
 * @author bob123
 * @since 2018-04-20
 */
@Api(tags="积分等级 管理端", description="积分等级 管理端")
@RestController
@RequestMapping("/manage/point/level")
public class PointLevelController {
	@Autowired
	PointLevelService pointLevelService;
	
	@PostMapping("/insert")
	Boolean inserts(@RequestBody com.yizhi.application.domain.PointLevel pointLevel){
		
		return pointLevelService.inserts(pointLevel);
	}
	
	@GetMapping("/update")
	Integer updateById(com.yizhi.application.domain.PointLevel pointLevel) {
		return pointLevelService.updateById1(pointLevel);
	}
	
	@PostMapping("/delete")
	Boolean piontLevelDelete(@RequestParam Long id) {
		return pointLevelService.piontLevelDelete(id);
	}
	
	@GetMapping("/list")
	public List<PointLevelVo> levelList(
			 @RequestParam Long id){
		List<PointLevel> pointLevels = pointLevelService.levelList(id);
		List<PointLevelVo> pointLevels1 = new ArrayList<>();
		for (PointLevel s:pointLevels
			 ) {
			PointLevelVo pointLevelVo =new PointLevelVo();
			BeanUtils.copyProperties(s,pointLevelVo);
			pointLevels1.add(pointLevelVo);
		}
		return pointLevels1;
	}
}

