package com.yizhi.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.context.annotation.Primary;

import javax.persistence.Entity;
import javax.persistence.Id;
import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 积分明细
 * </p>
 *
 * @author bob123
 * @since 2018-04-20
 */
@Data
@ApiModel(value = "PointDetailsVo", description = "积分详情")
@TableName("point_details")
@Entity
public class PointDetails extends Model<PointDetails> {

    private static final long serialVersionUID = 1L;

    @Id
	@ApiModelProperty(value = "积分明细ID")
    private Long id;

	@ApiModelProperty(value = "活动策略ID")
    @TableField("activity_id")
    private Long activityId;

//	@ApiModelProperty(value = "事件名称")
//	@TableField("event_name")
//	private String eventName;

	@ApiModelProperty(value = "时间")
    private Date time;

    @ApiModelProperty(value = "变动前积分总量")
    private Integer changeBefore;

	@ApiModelProperty(value = "积分")
    private Integer point;

    @ApiModelProperty(value = "变动后积分总量")
    private Integer changeAfter;

	@ApiModelProperty(value = "学员号")
    @TableField("account_id")
    private Long accountId;

	@ApiModelProperty(value = "学习活动类型")
    @TableField("learn_type")
    private String learnType;

	@ApiModelProperty(value = "学习活动名称")
    @TableField("learn_name")
    private String learnName;

	@ApiModelProperty(value = "学习活动来源")
    @TableField("learn_source")
    private String learnSource;

	@ApiModelProperty(value = "积分来源Id, 存放业务主键， 课程Id，调研Id，考试Id, 投票ID, 作业ID")
	@TableField("learn_source_id")
	private Long learnSourceId;

    @ApiModelProperty(value = "课程id(如果是课程按章节发放)")
    @TableField("course_id")
    private Long courseId;

//	@ApiModelProperty(value = "发放条件")
//	@TableField("release_condition")
//	private String releaseCondition;
//
//	@ApiModelProperty(value = "发放规则")
//	@TableField("release_rules")
//	private String releaseRules;

	@ApiModelProperty(value = "状态 0 删除， 1 未删除")
    private Integer state;

	@ApiModelProperty(value = "创建时间")
    @TableField("create_time")
    private Date createTime;

	@ApiModelProperty(value = "创建人")
    @TableField("create_by_id")
    private Long createById;

	@ApiModelProperty(value = "创建人姓名")
    @TableField("create_by_name")
    private String createByName;

	@ApiModelProperty(value = "修改时间")
    @TableField("update_time")
    private Date updateTime;

	@ApiModelProperty(value = "修改人")
    @TableField("update_by_id")
    private Long updateById;

	@ApiModelProperty(value = "修改人姓名")
    @TableField("update_by_name")
    private String updateByName;

	@ApiModelProperty(value = "公司ID")
    @TableField("company_id")
    private Long companyId;

	@ApiModelProperty(value = "部门ID")
    @TableField("org_id")
    private Long orgId;

	@ApiModelProperty(value = "站点ID")
    @TableField("site_id")
    private Long siteId;

    @ApiModelProperty(value = "积分活动翻倍的倍数")
    @TableField("multiple")
    private Integer multiple;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }
}
