package com.yizhi.application.listener;

import com.yizhi.application.constant.PointEventEnum;
import com.yizhi.application.domain.MqPointParam;
import com.yizhi.application.domain.Point;
import com.yizhi.application.domain.PointActivity;
import com.yizhi.application.domain.PointDetails;
import com.yizhi.application.domain.PointUser;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.redis.RedisUtils;
import com.yizhi.application.util.PointEvenSendMessage;
import com.yizhi.core.application.cache.distributedlock.impl.RedisDistributedLock;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.task.AbstractTaskHandler;
import com.yizhi.core.application.task.TaskExecutor;
import com.yizhi.message.application.enums.EvenType;
import com.yizhi.message.application.vo.TaskVo;
import com.yizhi.point.application.vo.PointParamVO;
import com.yizhi.application.service.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

@Component
@Transactional
public class PointListener {

	private static final Logger LOGGER = LoggerFactory.getLogger(PointListener.class);

	@Autowired
	private RedisUtils redisUtils;
	@Autowired
	private IdGenerator idGenerator;
	@Autowired
	private PointService pointService;
	@Autowired
	private PointDetailsService pointDetailsService;
	@Autowired
	private PointUserService pointUserService;
	@Autowired
	private PointActivityService pointActivityService;
	@Autowired
	private MqPointParamService mqPointParamService;
	@Autowired
	private TaskExecutor taskExecutor;
	@Autowired
	private PointEvenSendMessage pointEvenSendMessage;
	@Autowired
	private RedisDistributedLock redisDistributedLock;

	/*
	 * static { RedissonManager.init(null, "1"); }
	 */

	@RabbitListener(queues = "course")
	public void processCourse(String pointId) {
		LOGGER.info("------------处理消息course-----------------");
		handPoint(pointId);
	}

	@RabbitListener(queues = "research")
	public void processResearch(String pointId) {
		LOGGER.info("------------处理消息research-----------------");
		handPoint(pointId);
	}

	@RabbitListener(queues = "exam")
	public void processExam(String pointId) {
		LOGGER.info("------------处理消息exam-----------------");
		handPoint(pointId);
	}

	@RabbitListener(queues = "vote")
	public void processVote(String pointId) {
		LOGGER.info("------------处理消息vote-----------------");
		handPoint(pointId);
	}

	@RabbitListener(queues = "assignment")
	public void processAssignment(String pointId) {
		LOGGER.info("------------处理消息assignment-----------------");
		handPoint(pointId);
	}

	@RabbitListener(queues = "courseTest")
	public void processCourseTest(String pointId) {
		LOGGER.info("------------处理消息courseTest-----------------");
		handPoint(pointId);
	}

	@RabbitListener(queues = "practiceChat")
	public void processPractice(String pointId) {
		LOGGER.info("------------处理消息Practice-----------------");
		handPoint(pointId);
	}

	@RabbitListener(queues = "offlineCourse")
	public void processOfflineCourse(String pointId) {
		LOGGER.info("------------处理消息offlineCourse-----------------");
		handPoint(pointId);
	}

	@RabbitListener(queues = "trainingProject")
	public void processTrainingProject(String pointId) {
		LOGGER.info("------------处理消息trainingProject-----------------");
		handPoint(pointId);
	}

	@RabbitListener(queues = "caseLibrary")
	public void processCaseLibrary(String pointId) {
		LOGGER.info("------------处理消息caseLibrary-----------------");
		handPoint(pointId);
	}

	@RabbitListener(queues = "sign")
	public void processSign(String pointId) {
		LOGGER.info("------------处理消息sign-----------------");
		handPoint(pointId);
	}

	@RabbitListener(queues = "forum")
	public void processForum(String pointId) {
		LOGGER.info("------------处理消息sign-----------------");
		handPoint(pointId);
	}

	@RabbitListener(queues = "projectSign")
	public void processProjectSign(String pointId) {
		LOGGER.info("------------处理消息projectSign-----------------");
		handPoint(pointId);
	}

	// 处理积分
	public boolean handPoint(String pointId) {
		// TODO("积分重构")
	      PointParamVO vo = (PointParamVO) redisUtils.get(pointId);
			if (vo == null) {
				LOGGER.info("消息ID{}获取不到缓存信息");
				return false;
			}
	        String lockName = "pointOperate_sourceId:" + vo.getSourceId() + "_accountId:" + vo.getAccountId();
		try {
			if (null == pointId) {
				LOGGER.info("积分MQId为空");
				return false;
			}

			LOGGER.info("开始处理消息ID{},业务ID{} 的积分", pointId, vo.getSourceId());
			Map<String, Object> map = new HashMap<String, Object>();
			map.put("learn_source_id", vo.getSourceId());
			map.put("account_id", vo.getAccountId());
			List<PointDetails> selectByMap = pointDetailsService.selectByMap(map);
			String eventName = vo.getEventName();
			if (vo.getOperatingPoint() == null && vo.getOperatingPoint() == 0) {
				LOGGER.info("不产生0或空的积分，学员ID{},业务单据{}", vo.getAccountId(), vo.getSourceId());
				return false;
			}
			if (eventName.equals(PointEventEnum.POINTCOURSE.getKey())) { // 课程
				if (selectByMap.size() == 0 || selectByMap == null) {
					addHandPoint(pointId, vo);
				}
			} else if (eventName.equals(PointEventEnum.POINTEXAM.getKey())) { // 考试
				if (selectByMap.size() == 0 || selectByMap == null) {
					addHandPoint(pointId, vo);
				} else {
					addExamPoint(pointId, vo, selectByMap);
				}
			} else if (eventName.equals(PointEventEnum.POINTRESEARCH.getKey())) { // 调研
				if (selectByMap.size() == 0 || selectByMap == null) {
					addHandPoint(pointId, vo);
				}
			} else if (eventName.equals(PointEventEnum.POINTVOTE.getKey())) { // 投票
				if (selectByMap.size() == 0 || selectByMap == null) {
					addHandPoint(pointId, vo);
				}
			} else if (eventName.equals(PointEventEnum.POINTASSIGNMENT.getKey())) { // 作业
				if (selectByMap.size() == 0 || selectByMap == null) {
					addHandPoint(pointId, vo);
				}
			} else if (eventName.equals(PointEventEnum.POINTCOURSETEST.getKey())) { // 测验
				if (selectByMap.size() == 0 || selectByMap == null) {
					addHandPoint(pointId, vo);
				}
			} else if (eventName.equals(PointEventEnum.POINTOFFLINECOURSE.getKey())) { // 线下课程
				// 获得对应的记录以及积分，多则补总积分，少则减积分，并删除这条记录，添加导入的记录
				addCoursePoint(pointId, vo, selectByMap);
			} else if (eventName.equals(PointEventEnum.POINTTRAININGPROJECT.getKey())) { // 培训项目
				if (selectByMap.size() == 0 || selectByMap == null) {
					addHandPoint(pointId, vo);
				}
				/**
				 * 案例活动
				 */
			} else if (eventName.equals(PointEventEnum.POINTCASELIBRARY.getKey())) {
				if (selectByMap.size() == 0 || selectByMap == null) {
					addHandPoint(pointId, vo);
				}
				/**
				 * 签到打卡
				 */
			} else if (eventName.equals(PointEventEnum.POINTSIGN.getKey())) {
				if (selectByMap.size() == 0 || selectByMap == null) {
					addHandPoint(pointId, vo);
				}
				/**
				 * 论坛发贴/评论
				 */
			} else if (eventName.equals(PointEventEnum.POINTFORUM.getKey())) {
				if (selectByMap.size() == 0 || selectByMap == null) {
					addHandPoint(pointId, vo);
				}
				/**
				 * 项目签到
				 */
			} else if (eventName.equals(PointEventEnum.POINTPROJECTSIGN.getKey())) {
				if (selectByMap.size() == 0 || selectByMap == null) {
					addHandPoint(pointId, vo);
				}
				/**
				 * 智能演练
				 */
			} else if (eventName.equals(PointEventEnum.CHAPPRACTICE.getKey())) {
				if (selectByMap.size() == 0 || selectByMap == null) {
					addHandPoint(pointId, vo);
				}
			}
			try {
				redisUtils.remove(pointId);
			} catch (Exception e) {
				LOGGER.error("删除积分缓存失败{}", pointId);
				e.printStackTrace();
			}
			LOGGER.info("完成处理消息ID{},业务ID{} 的积分", pointId, vo.getSourceId());
		} catch (Exception e) {
			LOGGER.error("添加积分异常消息ID{}, 业务单据ID{},异常信息{}", pointId, vo.getSourceId(), e);
			// e.printStackTrace();
		} finally {
			// 一直报错，所以先不释放锁
			// pointOperate_sourceId:1764362179454753_accountId:607873925574006底层解锁发生异常{}
			//redis.clients.jedis.exceptions.JedisDataException: value sent to redis cannot be null
//			redisDistributedLock.releaseLock(lockName);
			LOGGER.info("释放reids锁" + lockName);
		}
		return true;
	}

	// 线下课程
	public boolean addCoursePoint(String pointId, PointParamVO vo, List<PointDetails> selectByMap) {
		PointDetails pd = new PointDetails();
		Integer point = vo.getOperatingPoint();
		if (!CollectionUtils.isEmpty(selectByMap)) {
			PointDetails pointDetail = selectByMap.get(0);
			vo.setOperatingPoint(vo.getOperatingPoint() - pointDetail.getPoint());
			// 删除旧的记录
			pointDetailsService.deleteById(pointDetail.getId());
		}
		Integer pointCount = pointDetailsService.getPointCountByAccountId(vo.getAccountId(), vo.getCompanyId(), vo.getSiteId());//导入用户在point_detail的总积分

		// 添加新的记录
		pd.setId(idGenerator.generate());
		pd.setChangeBefore(pointCount);
		pd.setPoint(point);
		pd.setChangeAfter(pointCount + point);
		pd.setActivityId(null);
		pd.setTime(vo.getCreatePointTime());
		pd.setMultiple(1);
		pd.setAccountId(vo.getAccountId());
		pd.setLearnName(vo.getActivityName());
		pd.setLearnSource("线下课程学习记录");
		pd.setLearnSourceId(vo.getSourceId());
		pd.setLearnType(vo.getActivityType());
		pd.setState(1);
		pd.setCreateById(vo.getAccountId());
		pd.setCreateByName(vo.getAccountName());
		pd.setCreateTime(vo.getCreatePointTime());
		pd.setOrgId(vo.getOrgId());
		pd.setCompanyId(vo.getCompanyId());
		pd.setSiteId(vo.getSiteId());
		pointDetailsService.insert(pd);
		// 计算个人总积分
		addPoint(pointId, vo.getAccountId(), vo.getOperatingPoint(), vo.getAccountName(), vo.getOrgId(),
				vo.getCompanyId(), vo.getSiteId(), vo.getCreatePointTime(), vo.getActivityType());
		return true;
	}

	// 考试
	@SuppressWarnings("unchecked")
	public boolean addExamPoint(String pointId, PointParamVO vo, List<PointDetails> selectByMap) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("site_id", vo.getSiteId());
		map.put("company_id", vo.getCompanyId());
		List<Point> selectByMap1 = pointService.selectByMap(map);
		if (selectByMap1 == null || selectByMap1.size() == 0) {
			return true;
		}
		Integer state = selectByMap1.get(0).getState();
		if (state == 0) {
			return true;
		}
		selectByMap.sort((PointDetails p1, PointDetails p2) -> p1.getTime().compareTo(p2.getTime()));
		Integer point = 0;
		Integer activityPoint = 0;
		// 某个活动对应的获取的总积分
		Integer totalActivityPoint = 0;
		Map<Long, Integer> pointDetailsMap = new HashMap<Long, Integer>(6);
		List<PointDetails> list = selectByMap.stream()
				.collect(Collectors.collectingAndThen(
						Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(PointDetails::getTime))),
						ArrayList::new));

		List<PointActivity> activities = pointActivityService.getPointActivity(vo.getCreatePointTime(),
				vo.getCompanyId(), vo.getSiteId());

		for (PointDetails pd : list) {
			if (pointDetailsMap.get(pd.getActivityId()) == null) {
				totalActivityPoint = pd.getPoint();
			} else {
				totalActivityPoint = pointDetailsMap.get(pd.getActivityId()) + pd.getPoint();
			}
			pointDetailsMap.put(pd.getActivityId(), totalActivityPoint);
			if (pd.getPoint() == null) {
				pd.setPoint(0);
			}
			point += pd.getPoint();
		}
		if (vo.getOperatingPoint() == null) {
			LOGGER.info("积分消息ID{},业务ID{} 积分为空", pointId, vo.getSourceId());
			vo.setOperatingPoint(0);
		}
		// 将要新增的获取积分明细
		PointDetails pd;
		// 将要新增的获取积分明细列表
		List<PointDetails> pdList = new ArrayList<PointDetails>(10);
		Integer pointCount = pointDetailsService.getPointCountByAccountId(vo.getAccountId(), vo.getCompanyId(), vo.getSiteId());//导入用户在point_detail的总积分
		// 没有翻倍
		if (CollectionUtils.isEmpty(activities)) {
			if (vo.getOperatingPoint() > point) {
				pd = new PointDetails();
				pd.setId(idGenerator.generate());
				pd.setTime(vo.getCreatePointTime());
				pd.setChangeBefore(pointCount);
				pd.setPoint(vo.getOperatingPoint() - point);
				pd.setChangeAfter(pointCount + vo.getOperatingPoint() - point);
				pd.setMultiple(1);
				pd.setAccountId(vo.getAccountId());
				pd.setLearnName(vo.getActivityName());
				pd.setLearnSource(vo.getActivitySource());
				pd.setLearnSourceId(vo.getSourceId());
				pd.setLearnType(vo.getActivityType());
				pd.setState(1);
				pd.setCreateById(vo.getAccountId());
				pd.setCreateByName(vo.getAccountName());
				pd.setCreateTime(vo.getCreatePointTime());
				pd.setOrgId(vo.getOrgId());
				pd.setCompanyId(vo.getCompanyId());
				pd.setSiteId(vo.getSiteId());
				pointDetailsService.insert(pd);
			}
		} else {
			for (PointActivity pointActivity : activities) {
				boolean add = false;
				pd = new PointDetails();
				if (pointDetailsMap.get(pointActivity.getId()) == null) {
					// 1.新增的活动,将新增的积分添加进pointDetails
					activityPoint = vo.getOperatingPoint() * pointActivity.getMultiple();
					pd.setChangeBefore(pointCount);
					pd.setPoint(activityPoint);
					pd.setChangeAfter(pointCount + activityPoint);
					add = true;
				} else {
					totalActivityPoint = pointDetailsMap.get(pointActivity.getId());
					activityPoint = vo.getOperatingPoint() * pointActivity.getMultiple();
					if (activityPoint > totalActivityPoint) {
						add = true;
						pd.setChangeBefore(pointCount);
						pd.setPoint(activityPoint - totalActivityPoint);
						pd.setChangeAfter(pointCount + activityPoint - totalActivityPoint);
					}
				}
				if (add) {
					pd.setId(idGenerator.generate());
					pd.setMultiple(pointActivity.getMultiple());
					pd.setActivityId(pointActivity.getId());
					pd.setTime(vo.getCreatePointTime());
					pd.setAccountId(vo.getAccountId());
					pd.setLearnName(vo.getActivityName());
					pd.setLearnSource(vo.getActivitySource());
					pd.setLearnSourceId(vo.getSourceId());
					pd.setLearnType(vo.getActivityType());
					pd.setState(1);
					pd.setCreateById(vo.getAccountId());
					pd.setCreateByName(vo.getAccountName());
					pd.setCreateTime(vo.getCreatePointTime());
					pd.setOrgId(vo.getOrgId());
					pd.setCompanyId(vo.getCompanyId());
					pd.setSiteId(vo.getSiteId());
					pdList.add(pd);
				}
			}
			if (pdList.size() > 0) {
				pointDetailsService.insertBatch(pdList);
			}
		}
		addPoint(pointId, vo.getAccountId(), point, vo.getAccountName(), vo.getOrgId(), vo.getCompanyId(),
				vo.getSiteId(), vo.getCreatePointTime(), vo.getActivityType());
		return true;
	}

	// 处理服务积分
	public boolean addHandPoint(String pointId, PointParamVO vo) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("site_id", vo.getSiteId());
		map.put("company_id", vo.getCompanyId());
		List<Point> selectByMap = pointService.selectByMap(map);
		if (selectByMap == null || selectByMap.size() == 0) {
			return true;
		}
		Integer state = selectByMap.get(0).getState();
		if (state == 0) {
			return true;
		}
		if (vo.getOperatingPoint() == null || vo.getOperatingPoint() == 0) {
			return true;
		}
		Integer pointCount = pointDetailsService.getPointCountByAccountId(vo.getAccountId(), vo.getCompanyId(), vo.getSiteId());//传入用户的金币总数
		List<PointActivity> list = pointActivityService.getPointActivity(vo.getCreatePointTime(), vo.getCompanyId(),
				vo.getSiteId());
		Integer point = 0;
		Integer operatingPoint = 0;
		Long accountId = vo.getAccountId();
		PointDetails pd = null;
		if (list.size() > 0) {
			List<PointDetails> pdList = new ArrayList<PointDetails>();
			for (PointActivity pa : list) {
				operatingPoint = vo.getOperatingPoint();
				if (operatingPoint == null) {
					LOGGER.info("积分消息ID{},业务ID{} 积分为空", pointId, vo.getSourceId());
					operatingPoint = 0;
				}
				operatingPoint = operatingPoint * pa.getMultiple();
				point += operatingPoint;
				pd = new PointDetails();
				pd.setId(idGenerator.generate());
				pd.setActivityId(pa.getId());
				pd.setTime(vo.getCreatePointTime());
				pd.setChangeBefore(pointCount);
				pd.setPoint(operatingPoint);
				pd.setChangeAfter(pointCount + operatingPoint);
				pd.setAccountId(accountId);
				pd.setLearnName(vo.getActivityName());
				pd.setLearnSource(vo.getActivitySource());
				pd.setLearnSourceId(vo.getSourceId());
				if (null != vo.getCourseId()) {
					pd.setCourseId(vo.getCourseId());
				}
				pd.setLearnType(vo.getActivityType());
				pd.setState(1);
				pd.setCreateById(vo.getAccountId());
				pd.setCreateByName(vo.getAccountName());
				pd.setCreateTime(vo.getCreatePointTime());
				pd.setOrgId(vo.getOrgId());
				pd.setCompanyId(vo.getCompanyId());
				pd.setSiteId(vo.getSiteId());
				pd.setMultiple(pa.getMultiple());
				pdList.add(pd);
			}
			if (pdList.size() > 0) {
				pointDetailsService.insertBatch(pdList);
			}
		} else {
			point = vo.getOperatingPoint();
			pd = new PointDetails();
			pd.setId(idGenerator.generate());
			pd.setTime(vo.getCreatePointTime());
			pd.setChangeBefore(pointCount);
			pd.setPoint(point);
			pd.setChangeAfter(pointCount + point);
			pd.setMultiple(1);
			pd.setAccountId(accountId);
			pd.setLearnName(vo.getActivityName());
			pd.setLearnSource(vo.getActivitySource());
			pd.setLearnSourceId(vo.getSourceId());
			if (null != vo.getCourseId()) {
				pd.setCourseId(vo.getCourseId());
			}
			pd.setLearnType(vo.getActivityType());
			pd.setState(1);
			pd.setCreateById(vo.getAccountId());
			pd.setCreateByName(vo.getAccountName());
			pd.setCreateTime(vo.getCreatePointTime());
			pd.setOrgId(vo.getOrgId());
			pd.setCompanyId(vo.getCompanyId());
			pd.setSiteId(vo.getSiteId());
			pointDetailsService.insert(pd);
		}

		try {
			addPoint(pointId, accountId, point, vo.getAccountName(), vo.getOrgId(), vo.getCompanyId(), vo.getSiteId(),
					vo.getCreatePointTime(), vo.getActivityType());
		} catch (Exception e) {
			LOGGER.error("userPoint插入过程中出现异常");
			e.printStackTrace();
		}
		return true;
	}

	// 个人积分统计
	private void addPoint(String pointId, Long accountId, Integer operatingPoint, String accountName, Long orgId,
			Long companyId, Long siteId, Date date, String learnType) {
		PointUser pu = null;
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("user_id", accountId);
		List<PointUser> selectByMap = pointUserService.selectByMap(map);
		Long id = idGenerator.generate();
		if (selectByMap == null || selectByMap.size() == 0) {
			pu = new PointUser();
			pu.setId(id);
			pu.setUserId(accountId);
			pu.setTotalPoint(operatingPoint);
			pu.setState(1);
			pu.setCreateById(accountId);
			pu.setCreateByName(accountName);
			pu.setCreateTime(date);
		} else {
			pu = selectByMap.get(0);
			pu.setTotalPoint(pu.getTotalPoint() + operatingPoint);
			pu.setUpdateById(accountId);
			pu.setUpdateByName(accountName);
			pu.setUpdateTime(date);
		}
		pu.setOrgId(orgId);
		pu.setSiteId(siteId);
		pu.setCompanyId(companyId);
		boolean b = pointUserService.insertOrUpdate(pu);

		// 个人积分变动发消息
		if (b && accountId != null) {
			TaskVo taskVo = new TaskVo();
			taskVo.setReason(learnType);
			taskVo.setTaskEndTime(pu.getUpdateTime());
			taskVo.setTaskScore(operatingPoint.doubleValue());
			RequestContext context = new RequestContext();
			context.setCompanyId(companyId);
			context.setSiteId(siteId);
			context.setAccountId(accountId);
			context.setAccountName(accountName);
			taskExecutor.asynExecute(new AbstractTaskHandler() {
				@Override
				public void handle() {
					pointEvenSendMessage.evenSendMessage(id, taskVo, accountId, EvenType.POINT_CHANGE, context);
				}
			});

		}

		MqPointParam selectById = mqPointParamService.selectById(pointId);
		selectById.setState(0);
		mqPointParamService.updateById(selectById);

		String key = accountId.toString();
//		DistributedRedisLock.acquire(key);  //加锁
		Integer userPoint = (Integer) redisUtils.get(key);
		if (userPoint == null) {
			redisUtils.set(key, operatingPoint);
		} else {
			redisUtils.set(key, userPoint + operatingPoint);
		}
//		Long result = RedissonManager.nextID();  //原子ID
//		DistributedRedisLock.release(key);  //解锁
//		System.out.println("result=" + result);
		redisUtils.remove(pointId);
	}
}
