package com.yizhi.point.application.feign;

import com.yizhi.point.application.vo.PointParamVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name = "point", contextId = "PointRedisFeignClients")
public interface PointRedisFeignClients {

	@PostMapping("/point/redis/add")
	String addPointRedis(@RequestBody PointParamVO vo);

	@PostMapping("/point/add")
	void pointAdd(
			@RequestParam(name = "type",required = false)String type,
			@RequestParam(name = "accountId",required = false)Long accountId,
			@RequestParam(name = "sourceId",required = false)String sourceId);
}
