package com.yizhi.application.service.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.application.domain.PointActivity;
import com.yizhi.application.mapper.PointActivityMapper;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.service.PointActivityService;
import com.yizhi.core.application.context.ContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;

/**
 * <p>
 * 活动策略 服务实现类
 * </p>
 *
 * @author bob123
 * @since 2018-04-20
 */
@Service
public class PointActivityServiceImpl extends ServiceImpl<PointActivityMapper, com.yizhi.application.domain.PointActivity> implements PointActivityService {
	
	@Autowired
	IdGenerator idGenerator ;
	@Autowired
	PointActivityMapper pointActivityMapper;
	
	@Override
	public Long insertDetail(com.yizhi.application.domain.PointActivity pointActivity) {
		Long companyId = ContextHolder.get().getCompanyId();
		Long orgId = ContextHolder.get().getOrgId();
		Long siteId = ContextHolder.get().getSiteId();
		pointActivity.setId(idGenerator.generate());
		pointActivity.setCompanyId(companyId);
		pointActivity.setOrgId(orgId);
		pointActivity.setSiteId(siteId);
		Integer count = pointActivityMapper.insert(pointActivity);
		if(count > 0){
			return pointActivity.getId();
		}
		
		return null;
	}

    @Override
    public Long deleteDetailById(com.yizhi.application.domain.PointActivity pointActivity) {
        com.yizhi.application.domain.PointActivity tem = new com.yizhi.application.domain.PointActivity();
        tem.setId(pointActivity.getId());
        int count = pointActivityMapper.selectCount(new EntityWrapper<com.yizhi.application.domain.PointActivity>(tem));
        if(count<=0){
            return -1L;
        }
        pointActivity.setState(0);

        return (long) pointActivityMapper.updateById(pointActivity);
    }

	@Override
	public Boolean pointUp(Long id, Long accountId, String accountName) {
		com.yizhi.application.domain.PointActivity pointActivity = new com.yizhi.application.domain.PointActivity();
		Date date = new Date();
		pointActivity.setId(id);
		pointActivity.setState(2);
		pointActivity.setUpdateById(accountId);
		pointActivity.setUpdateByName(accountName);
		pointActivity.setUpdateTime(date);
		pointActivity.setEnableById(accountId);
		pointActivity.setEnableByName(accountName);
		pointActivity.setEnableTime(date);
		return pointActivityMapper.updateById(pointActivity)>0;
	}

	@Override
	public Boolean pointDown(Long id, Long accountId, String accountName) {
		com.yizhi.application.domain.PointActivity pointActivity = new com.yizhi.application.domain.PointActivity();
		Date date = new Date();
		pointActivity.setId(id);
		pointActivity.setState(3);
		pointActivity.setUpdateById(accountId);
		pointActivity.setUpdateByName(accountName);
		pointActivity.setUpdateTime(date);
		pointActivity.setEnableById(accountId);
		pointActivity.setEnableByName(accountName);
		pointActivity.setEnableTime(date);
		return pointActivityMapper.updateById(pointActivity)>0;
	}

	@Override
	public Page<com.yizhi.application.domain.PointActivity> activityList(Page<com.yizhi.application.domain.PointActivity> page, Map<String, Object> map) {
		Long companyId = Long.valueOf((String)map.get("companyId"));
		Long siteId = Long.valueOf((String)map.get("siteId")); 
		String activityName = (String) map.get("activityName");
		String code = (String) map.get("code");
		List<com.yizhi.application.domain.PointActivity> list = pointActivityMapper.activityList(page, companyId, siteId, activityName,code);
		return page.setRecords(list);
	}

	@Override
	public List<PointActivity> getPointActivity(Date createPointTime, Long companyId, Long siteId) {
		return pointActivityMapper.getPointActivity(createPointTime, companyId, siteId);
	}

}
