package com.yizhi.application.service.impl;

import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.application.domain.PointProduct;
import com.yizhi.application.mapper.PointProductMapper;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.service.PointProductService;
import com.yizhi.point.application.vo.PointSearchParamVO;
import com.yizhi.point.application.vo.domain.PointProductVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 活动策略 服务实现类
 * </p>
 *
 * @author bob123
 * @since 2018-04-20
 */
@Service
@Slf4j
public class PointProductServiceImpl extends ServiceImpl<PointProductMapper, PointProduct> implements PointProductService {
	
	@Autowired
	IdGenerator idGenerator ;
	@Autowired
	PointProductMapper pointProductMapper;
	
	@Override
	public Long insertDetail(PointProduct pointProduct) {
		pointProduct.setId(idGenerator.generate());
		Integer count = pointProductMapper.insert(pointProduct);
		if(count > 0){
			return pointProduct.getId();
		}
		
		return null;
	}

    @Override
    public Long deleteDetailById(PointProduct pointProduct) {
		PointProduct tem = new PointProduct();
        tem.setId(pointProduct.getId());
        int count = pointProductMapper.selectCount(new EntityWrapper<PointProduct>(tem));
		log.info("删除积分商品时判断是否存在:{}", count);
        if(count<=0){
            return -1L;
        }
		pointProduct.setState(0);
		log.info("删除积分商品update入参:{}", JSONUtil.toJsonStr(pointProduct));
        return (long) pointProductMapper.updateById(pointProduct);
    }

	@Override
	public Boolean pointUp(Long id, Long accountId, String accountName) {
		PointProduct pointProduct = new PointProduct();
		Date date = new Date();
		pointProduct.setId(id);
		pointProduct.setState(1);
		pointProduct.setUpdateById(accountId);
		pointProduct.setUpdateByName(accountName);
		pointProduct.setUpdateTime(date);
		return pointProductMapper.updateById(pointProduct)>0;
	}

	@Override
	public Boolean pointDown(Long id, Long accountId, String accountName) {
		PointProduct pointProduct = new PointProduct();
		Date date = new Date();
		pointProduct.setId(id);
		pointProduct.setState(2);
		pointProduct.setUpdateById(accountId);
		pointProduct.setUpdateByName(accountName);
		pointProduct.setUpdateTime(date);
		return pointProductMapper.updateById(pointProduct)>0;
	}

	@Override
	public Page<PointProductVo> productList(PointSearchParamVO searchParamVO) {
		Page<PointProductVo> page = new Page<>(searchParamVO.getPageNo(), searchParamVO.getPageSize());
		List<PointProductVo> list = pointProductMapper.productList(page, searchParamVO.getName());
		return page.setRecords(list);
	}

	@Override
	public List<PointProductVo> productListExchange(Integer pageNo, Integer pageSize) {
		Page<PointProductVo> page = new Page<>(pageNo, pageSize);
		return pointProductMapper.productListExchange(page);
	}
}