package com.yizhi.application.controller;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.domain.MqPointParam;
import com.yizhi.application.domain.PointActivity;
import com.yizhi.application.orm.util.DomainConverter;
import com.yizhi.application.service.MqPointParamService;
import com.yizhi.application.service.PointActivityService;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.point.application.vo.domain.MqPointParamVo;
import com.yizhi.point.application.vo.domain.PointActivityVo;
import io.swagger.annotations.Api;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 活动策略 前端控制器
 * </p>
 *
 * @author bob123
 * @since 2018-04-20
 */
@Api(tags = "活动策略 管理端", description = "活动策略 管理端")
@RestController
@RequestMapping("/manage/activity")
public class PointActivityController {

    private static final Logger LOG = LoggerFactory.getLogger(PointActivityController.class);

    @Autowired
    PointActivityService pointActivityService;
    @Autowired
    IdGenerator idGenerator;
    @Autowired
    MqPointParamService mqPointParamService;

    @Autowired
    DomainConverter domainConverter;

    @PostMapping("/insert")
    Long insertDetail(@RequestBody PointActivityVo pointActivityVo) {
        if (null == pointActivityVo) {
            return null;
        }
        PointActivity pointActivity1 = new PointActivity();
        BeanUtils.copyProperties(pointActivityVo, pointActivity1);
        return pointActivityService.insertDetail(pointActivity1);
    }

    @PostMapping("/update")
    Long updateById(@RequestBody PointActivityVo pointActivityVo) {
        if (null == pointActivityVo) {
            return null;
        }

        PointActivity pointActivity1 = new PointActivity();;
        BeanUtils.copyProperties(pointActivityVo, pointActivity1);
        Boolean isOk = pointActivityService.updateById(pointActivity1);
        if (isOk) {
            return pointActivityVo.getId();
        }
        return null;
    }

    @PostMapping("/delete")
    Long deleteDetailById(@RequestBody PointActivityVo pointActivityVo) {
        if (null == pointActivityVo) {
            return null;
        }
        PointActivity pointActivity1 = new PointActivity();
        BeanUtils.copyProperties(pointActivityVo, pointActivity1);
        Long i = pointActivityService.deleteDetailById(pointActivity1);

        return i;
    }

    @PostMapping("/enabled")
    Boolean bannerUp(@RequestBody PointActivityVo pointActivityVo) {
        if (null == pointActivityVo) {
            return false;
        }
        PointActivity pointActivity1 = new PointActivity();
        BeanUtils.copyProperties(pointActivityVo, pointActivity1);
        return pointActivityService.pointUp(pointActivity1.getId(), pointActivity1.getUpdateById(), pointActivity1.getUpdateByName());
    }

    @PostMapping("/disabled")
    Boolean bannerDown(@RequestBody PointActivityVo pointActivityVo) {
        if (null == pointActivityVo) {
            return false;
        }
        PointActivity pointActivity1 = new PointActivity();
        BeanUtils.copyProperties(pointActivityVo, pointActivity1);
        return pointActivityService.pointDown(pointActivity1.getId(), pointActivity1.getUpdateById(), pointActivity1.getUpdateByName());
    }

    @GetMapping("/byCode")
    public PointActivityVo getActivity(@RequestParam("code") String code){
        PointActivity pointActivity = new PointActivity();
        pointActivity.setCode(code);
        pointActivity.setState(2);
        EntityWrapper<PointActivity> entityWrapper = new EntityWrapper<PointActivity>();
        PointActivityVo activityVo = new PointActivityVo();
        PointActivity activity = pointActivityService.selectOne(entityWrapper);
        if(activity==null){
            return activityVo;
        }
        BeanUtils.copyProperties(activity,activityVo);
        return activityVo;
    }

    @GetMapping("/list")
    public Page<PointActivityVo> activityList(@RequestParam Map<String, Object> map) {
        Page<PointActivity> list = null;
        Page<PointActivityVo> list2 = null;
        if (null == map) {
            return null;
        }

        try {
            Integer pageNo = Integer.valueOf((String) map.get("pageNo"));
            Integer pageSize = Integer.valueOf((String) map.get("pageSize"));
            Page<PointActivity> page = new Page<PointActivity>(pageNo, pageSize);
            list = pointActivityService.activityList(page, map);
            list2 = new Page<>(pageNo, pageSize);
            List<PointActivity> records = list.getRecords();
            List<PointActivityVo> list1 = domainConverter.toDOList(records, PointActivity.class);
            BeanUtils.copyProperties(list, list2);
            list2.setRecords(list1);
        } catch (Exception e) {
            LOG.error("服务出错。", e);
        }
        return list2;
    }

    @GetMapping("/getPointRecords")
    List<MqPointParamVo> getPointRecords(String eventName, Long activityId, Long companyId, Long siteId) {

        MqPointParam mqPointParam = new MqPointParam();
        mqPointParam.setEventName(eventName);
        mqPointParam.setSourceId(activityId);
        mqPointParam.setCompanyId(companyId);
        mqPointParam.setSiteId(siteId);
        mqPointParam.setState(1);

        EntityWrapper<MqPointParam> entityWrapper = new EntityWrapper<>(mqPointParam);
        entityWrapper.groupBy("account_id");
        List<MqPointParam> list = mqPointParamService.selectList(entityWrapper);
        List<MqPointParamVo> list2 = null;
        BeanUtils.copyProperties(list, list2);
        return list2;
    }
}

