package com.yizhi.application.mapper;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.domain.PointDetails;
import com.yizhi.point.application.vo.PointDetailListVO;
import com.yizhi.point.application.vo.PointDetailsVO;
import com.yizhi.point.application.vo.domain.PointDetailsVo;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 积分明细 Mapper 接口
 * </p>
 *
 * @author bob123
 * @since 2018-04-20
 */
public interface PointDetailsMapper extends BaseMapper<PointDetails> {

    List<PointDetailsVO> todayList(@Param("accountId") Long accountId, @Param("companyId") Long companyId,
                                   @Param("siteId") Long siteId, @Param("orgId") Long orgId);

    List<PointDetailsVO> aMonthList(@Param("page") Page<PointDetailsVO> page, @Param("year") String year,
                                    @Param("type") String type, @Param("accountId") Long accountId, @Param("companyId") Long companyId,
                                    @Param("siteId") Long siteId, @Param("orgId") Long orgId);

    Integer queryPiont(@Param("userId") Long userId, @Param("type") String type, @Param("companyId") Long companyId,
                       @Param("siteId") Long siteId, @Param("orgId") Long orgId);

    List<PointDetailsVO> getManagePointDetails(@Param("page") Page<PointDetailsVO> page, @Param("activityId") Long activityId,
                                               @Param("accountIds") List<Long> accountIds, @Param("startTime") Date startTime, @Param("endTime") Date endTime,
                                               @Param("companyId") Long companyId, @Param("siteId") Long siteId);

    List<PointDetails> getReportPoints(@Param("bizId") Long bizId, @Param("accountId") Long accountId,
                                       @Param("companyId") Long companyId, @Param("siteId") Long siteId,
                                       @Param("isRealTime") boolean isRealTime);

    List<PointDetails> getCourseReportPoints(@Param("bizId") Long bizId, @Param("accountId") Long accountId,
                                             @Param("isRealTime") boolean isRealTime);


    List<PointDetails> getCourseStatisticsPoint();

    List<PointDetails> getNoCourseStatisticsPoint();

    Integer getPointByCondition(@Param("accountId") Long accountId, @Param("siteId") Long siteId, @Param("bizIds") List<Long> bizIds);

    /**
     * 查询积分明细数据
     * @param startDate 开始时间 默认访问接口前一天 00:00:00
     * @param endDate 统计截至时间 默认访问接口前一天 23:59:59
     * @param companyId 统计公司id
     * @param siteId 统计站点id
     * @return 积分明细list
     */
    List<PointDetailsVo> selectPointDetails(@Param("startDate") Date startDate,
                                            @Param("endDate") Date endDate,
                                            @Param("companyId") Long companyId,
                                            @Param("siteId") Long siteId);

//    @Update("UPDATE point_details c\n" +
//            "        LEFT JOIN (\n" +
//            "            SELECT\n" +
//            "                d1.id AS id,\n" +
//            "                sum( d2.point ) AS sum_of_point\n" +
//            "            FROM\n" +
//            "                point_details d1\n" +
//            "                LEFT JOIN point_details d2 ON d1.account_id = d2.account_id\n" +
//            "                AND d1.site_id = d2.site_id\n" +
//            "                AND d1.company_id = d2.company_id\n" +
//            "            WHERE\n" +
//            "                d1.id >= d2.id\n" +
//            "                AND d1.site_id = #{siteId}\n" +
//            "                AND d1.account_id = #{accountId}\n" +
//            "            GROUP BY\n" +
//            "                d1.account_id,\n" +
//            "                d1.company_id,\n" +
//            "                d1.id\n" +
//            "            ) AS d ON c.id = d.id\n" +
//            "            SET c.change_after = d.sum_of_point\n" +
//            "        WHERE\n" +
//            "            c.site_id = #{siteId} and\n" +
//            "            c.account_id = #{accountId}")
    void updateChangeAfter(@Param("accountId") Long accountId, @Param("siteId") Long siteId);

    List<Long> getAllAccountIds(@Param("siteId") Long siteId);

    List<Long> getAllSiteIds();

    Integer getPointCountByAccountId(@Param("accountId") Long accountId,
                                     @Param("companyId") Long companyId,
                                     @Param("siteId") Long siteId);

    Integer selectPointVo(@Param("accountId") Long accountId, @Param("siteId")Long siteId, @Param("type")String type,@Param("toDay")String toDay);

    Integer getAmount(@Param("accountId") Long accountId, @Param("siteId")Long siteId);

    Integer getCountToDay(@Param("accountId") Long accountId, @Param("siteId")Long siteId, @Param("type")String type,@Param("toDay")String toDay);

    List<PointDetailListVO> getPointDetailsList(@Param("accountId") Long accountId, @Param("pageNo") Integer pageNo, @Param("pageSize") Integer pageSize);
}
