package com.yizhi.application.service;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.IService;
import com.yizhi.application.domain.PointDetails;
import com.yizhi.point.application.vo.PointDetailListVO;
import com.yizhi.point.application.vo.PointDetailVO;
import com.yizhi.point.application.vo.PointDetailsVO;
import com.yizhi.point.application.vo.PointImportVO;
import com.yizhi.point.application.vo.domain.PointDetailsVo;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 积分明细 服务类
 * </p>
 *
 * @author bob123
 * @since 2018-04-20
 */
public interface PointDetailsService extends IService<PointDetails> {

    Map<String, Object> pointList(String year, String type, Long accountId, Integer pageNo, Integer pageSize, Long companyId,
                                  Long siteId, Long orgId);

    PointDetailVO getPointDetail(Long accountId, Long siteId);

    Integer getCountToDay(Long accountId,Long siteId,String type);

    Integer queryPiont(Long userId, Long companyId, Long siteId, Long orgId);

    Page<PointDetailsVO> getManagePointDetails(Integer pageNo, Integer pageSize, Long activityId,
                                               List<Long> accountIds, Date startTime, Date endTime, Long companyId, Long siteId);

    boolean pointImport(List<PointImportVO> importVOList, Long companyId, Long siteId, Long orgId, Long accountId, String accountName);

    List<PointDetails> getReportPoints(Long bizId, Long accountId, Long companyId, Long siteId, boolean isRealTime);

    List<PointDetails> getCourseReportPoints(Long bizId, Long accountId, boolean isRealTime);

    List<PointDetails> statisticsPoint();

    Integer getPointByCondition(Long accontId,Long siteId,List<Long> bizIds);

    /**
     * 查询积分明细数据
     * @param startDate 开始时间 默认访问接口前一天 00:00:00
     * @param endDate 统计截至时间 默认访问接口前一天 23:59:59
     * @param companyId 统计公司id
     * @param siteId 统计站点id
     * @return 积分明细list
     *
     */
    List<PointDetailsVo> syncPointDetails(Date startDate, Date endDate, Long companyId, Long siteId);

    /**
     * 获取传入用户的积分总量
     *
     * @param id
     * @param companyId
     * @param accountId
     * @return
     */
    Integer getPointCountByAccountId(Long accountId, Long companyId, Long siteId);

    void updateChangeAfter(Long accountId,Long siteId);

    List<PointDetailListVO> getPointDetailsList(Long accountId, Integer pageNo, Integer pageSize);
}
