package com.yizhi.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 活动策略
 * </p>
 *
 * @author bob123
 * @since 2018-04-20
 */
@Data
@ApiModel(value = "PointActivityVo", description = "积分策略")
@TableName("point_activity")
public class PointActivity extends Model<PointActivity> {

    private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "活动策略ID")
    private Long id;

	@ApiModelProperty(value = "活动策略名称")
    @TableField("activity_name")
    private String activityName;

	@ApiModelProperty(value = "默认为1，不翻倍")
    private Integer multiple;

	@ApiModelProperty(value = "发放开始时间")
    @TableField("start_time")
    private Date startTime;

	@ApiModelProperty(value = "发放结束时间")
    @TableField("end_time")
    private Date endTime;

    @ApiModelProperty(value = "活动编号")
    @TableField("code")
    private String code;

    @ApiModelProperty(value = "事件类型/学习活动类型, 枚举 统一传入 ActivityTypeEnum.类型")
    @TableField("activity_type")
    private String activityType;

	@ApiModelProperty(value = "0删除 1草稿  2启用  3未启用")
    private Integer state;

	@ApiModelProperty(value = "创建时间")
    @TableField("create_time")
    private Date createTime;

	@ApiModelProperty(value = "创建人")
    @TableField("create_by_id")
    private Long createById;

	@ApiModelProperty(value = "创建人姓名")
    @TableField("create_by_name")
    private String createByName;

	@ApiModelProperty(value = "修改时间")
    @TableField("update_time")
    private Date updateTime;

	@ApiModelProperty(value = "修改人")
    @TableField("update_by_id")
    private Long updateById;

	@ApiModelProperty(value = "修改人姓名")
    @TableField("update_by_name")
    private String updateByName;

	@ApiModelProperty(value = "启用时间")
    @TableField("enable_time")
    private Date enableTime;

	@ApiModelProperty(value = "启用人")
    @TableField("enable_by_id")
    private Long enableById;

	@ApiModelProperty(value = "启用人姓名")
    @TableField("enable_by_name")
    private String enableByName;

	@ApiModelProperty(value = "公司ID")
    @TableField("company_id")
    private Long companyId;

	@ApiModelProperty(value = "部门ID")
    @TableField("org_id")
    private Long orgId;

	@ApiModelProperty(value = "站点ID")
    @TableField("site_id")
    private Long siteId;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }
}
