package com.yizhi.application.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.yizhi.application.constant.PointChangeReasonConstant;
import com.yizhi.application.domain.PointDetails;
import com.yizhi.application.domain.PointUser;
import com.yizhi.application.mapper.PointDetailsMapper;
import com.yizhi.application.mapper.PointMapper;
import com.yizhi.application.mapper.PointUserMapper;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.repository.PointDetailsRepository;
import com.yizhi.application.service.PointDetailsService;
import com.yizhi.application.service.PointUserService;
import com.yizhi.point.application.vo.*;
import com.yizhi.point.application.vo.domain.PointDetailsVo;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.sql.Connection;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 积分明细 服务实现类
 * </p>
 *
 * @author bob123
 * @since 2018-04-20
 */
@Service
@Log4j2
public class PointDetailsServiceImpl extends ServiceImpl<PointDetailsMapper, com.yizhi.application.domain.PointDetails> implements PointDetailsService {

    @Autowired
    PointDetailsMapper pointDetailsMapper;

    @Autowired
    PointUserMapper pointUserMapper;

    @Autowired
    PointUserService pointUserService;

    @Autowired
    PointMapper pointMapper;

    @Autowired
    IdGenerator idGenerator;

    @Autowired
    PointDetailsRepository pointDetailsRepository;

    private String updateSql = "";
    @Override
    public void updateChangeAfter(Long accountId, Long siteId) {
        Long time = System.currentTimeMillis();
        if (siteId == null) {
            List<Long> siteIds = pointDetailsMapper.getAllSiteIds();
            siteIds.stream().filter(Objects::nonNull).forEach(it -> {
                List<Long> accountIds = pointDetailsMapper.getAllAccountIds(it);
                accountIds.parallelStream().forEach( aid -> {
                    try {
                        executeSql(it,aid);
                    }catch (Exception e) {
                        log.warn("更新用户积分记录异常 aid：{} siteId: {}",aid,it,e);
                    }
                });
            });
            log.info("总耗时 " + (System.currentTimeMillis() - time) /1000 + " 秒");
            return;
        }

        // 更新指定站点指定用户
        if (accountId != null) {
            executeSql(siteId,accountId);
            return;
        }

        // 更新指定站点所有用户
        List<Long> accountIds = pointDetailsMapper.getAllAccountIds(siteId);
        accountIds.parallelStream().forEach( aid -> {
            log.info("更新用户积分记录 aid：{} siteId: {}",aid,siteId);
            executeSql(siteId,aid);
        });
    }


    private void executeSql(Long siteId,Long accountId) {
        if (siteId == null || accountId == null) {
            log.warn("更新用户积分记录 参数异常 accountId：{} siteId: {}",accountId,siteId);
            return;
        }
        log.info("更新用户积分记录 accountId：{} siteId: {}",accountId,siteId);
        pointDetailsRepository.updatePoint(siteId,accountId);
    }

    @Override
    public Map<String, Object> pointList(String year, String type, Long accountId, Integer pageNo, Integer pageSize, Long companyId,
                                         Long siteId, Long orgId) {

        if (!StringUtils.isBlank(year)) {
            year = year.trim();
        }
        Page<PointDetailsVO> page = new Page<PointDetailsVO>(pageNo, pageSize);
        List<PointDetailsVO> list1 = pointDetailsMapper.aMonthList(page, year, type, accountId, companyId, siteId, null);
        List<PointDetailsVO> pointList = list1.parallelStream().map(pointDetailsVO -> {
            if(pointDetailsVO.getLearnType()==null){
                pointDetailsVO.setLearnType("");
            }
            log.info("类型：" + pointDetailsVO.getLearnType());
            if (pointDetailsVO.getLearnType().contains(PointChangeReasonConstant.CREDITEXAMDONE.getValue())) {
                // 考试阅卷通过
                pointDetailsVO.setChangeReason(PointChangeReasonConstant.CREDITEXAMDONE.getKey());
                log.info("类型：" + pointDetailsVO.getLearnType());
                return pointDetailsVO;
            } else if (pointDetailsVO.getLearnType().contains(PointChangeReasonConstant.CREDITCOURSEDONE1.getValue())) {
                // 课程完成
                pointDetailsVO.setChangeReason(PointChangeReasonConstant.CREDITCOURSEDONE1.getKey());
                return pointDetailsVO;
            } else if (pointDetailsVO.getLearnType().contains(PointChangeReasonConstant.CREDITEXAMPASSED.getValue())) {
                pointDetailsVO.setChangeReason(PointChangeReasonConstant.CREDITEXAMPASSED.getKey());
                log.info("类型：" + pointDetailsVO.getLearnType());
                return pointDetailsVO;
            } else if (pointDetailsVO.getLearnType().contains(PointChangeReasonConstant.CREDITRESEARCHDONE.getValue())) {
                // 考试通过
                pointDetailsVO.setChangeReason(PointChangeReasonConstant.CREDITRESEARCHDONE.getKey());
                log.info("类型：" + pointDetailsVO.getLearnType());
                return pointDetailsVO;
            } else if (pointDetailsVO.getLearnType().contains(PointChangeReasonConstant.CREDITCOURSECHAPTERDONE.getValue())) {
                // 课程章节完成
                pointDetailsVO.setChangeReason(PointChangeReasonConstant.CREDITCOURSECHAPTERDONE.getKey());
                log.info("类型：" + pointDetailsVO.getLearnType());
                return pointDetailsVO;
            } else if (pointDetailsVO.getLearnType().contains(PointChangeReasonConstant.CREDITQUIZPASSED.getValue())) {
                // 课程章节测验通过
                pointDetailsVO.setChangeReason(PointChangeReasonConstant.CREDITCOURSECHAPTERDONE.getKey());
                log.info("类型：" + pointDetailsVO.getLearnType());
                return pointDetailsVO;
            } else if (pointDetailsVO.getLearnType().contains(PointChangeReasonConstant.CREDITOFFLINEDONE.getValue())) {
                // 线下课程完成
                pointDetailsVO.setChangeReason(PointChangeReasonConstant.CREDITOFFLINEDONE.getKey());
                log.info("类型：" + pointDetailsVO.getLearnType());
                return pointDetailsVO;
            } else if (pointDetailsVO.getLearnType().contains(PointChangeReasonConstant.CREDITCOURSEDONE2.getValue())) {
                // 课程学习完成
                pointDetailsVO.setChangeReason(PointChangeReasonConstant.CREDITCOURSEDONE2.getKey());
                log.info("类型：" + pointDetailsVO.getLearnType());
                return pointDetailsVO;
            } else if (pointDetailsVO.getLearnType().contains(PointChangeReasonConstant.CREDITASSIGNMENTPASSED.getValue())) {
                // 作业通过
                pointDetailsVO.setChangeReason(PointChangeReasonConstant.CREDITASSIGNMENTPASSED.getKey());
                log.info("类型：" + pointDetailsVO.getLearnType());
                return pointDetailsVO;
            } else if (pointDetailsVO.getLearnType().contains(PointChangeReasonConstant.CREDITEXTERNALIMPORT.getValue())) {
                // 外部导入
                pointDetailsVO.setChangeReason(PointChangeReasonConstant.CREDITEXTERNALIMPORT.getKey());
                log.info("类型：" + pointDetailsVO.getLearnType());
                return pointDetailsVO;
            } else if (pointDetailsVO.getLearnType().contains(PointChangeReasonConstant.CREDITTRAININGPROJECTDONE.getValue())) {
                // 培训项目通过
                pointDetailsVO.setChangeReason(PointChangeReasonConstant.CREDITTRAININGPROJECTDONE.getKey());
                log.info("类型：" + pointDetailsVO.getLearnType());
                return pointDetailsVO;
            } else if (pointDetailsVO.getLearnType().contains(PointChangeReasonConstant.CREDITCASELIBRARYDONE.getValue())) {
                pointDetailsVO.setChangeReason(PointChangeReasonConstant.CREDITCASELIBRARYDONE.getKey());
                log.info("类型：" + pointDetailsVO.getLearnType());
                return pointDetailsVO;
            } else if (pointDetailsVO.getLearnType().contains(PointChangeReasonConstant.CREDITCALENDARDONE.getValue())) {
                pointDetailsVO.setChangeReason(PointChangeReasonConstant.CREDITCALENDARDONE.getKey());
                log.info("类型：" + pointDetailsVO.getLearnType());
                return pointDetailsVO;
                //发布论坛回复发放积分
            } else if (pointDetailsVO.getLearnType().contains(PointChangeReasonConstant.CREDITFORUMCOMMENT.getValue())) {
                pointDetailsVO.setChangeReason(PointChangeReasonConstant.CREDITFORUMCOMMENT.getKey());
                pointDetailsVO.setLearnName(PointChangeReasonConstant.CREDITFORUMCOMMENT.getValue());
                log.info("类型：" + pointDetailsVO.getLearnType());
                return pointDetailsVO;
                //发布论坛帖子发放积分
            } else if (pointDetailsVO.getLearnType().contains(PointChangeReasonConstant.CREDITFORUMINVITATION.getValue())) {
                pointDetailsVO.setChangeReason(PointChangeReasonConstant.CREDITFORUMINVITATION.getKey());
                pointDetailsVO.setLearnName(PointChangeReasonConstant.CREDITFORUMINVITATION.getValue());
                log.info("类型：" + pointDetailsVO.getLearnType());
                return pointDetailsVO;
            } else if (pointDetailsVO.getLearnType().contains(PointChangeReasonConstant.CREDITSIGNDONE.getValue())) {
                pointDetailsVO.setChangeReason(PointChangeReasonConstant.CREDITSIGNDONE.getKey());
//                pointDetailsVO.setLearnName(PointChangeReasonConstant.CREDITSIGNDONE.getValue());
                log.info("类型：" + pointDetailsVO.getLearnType());
                return pointDetailsVO;
            } else {
                return pointDetailsVO;
            }

        }).collect(Collectors.toList());

        String unit = pointMapper.selectUnit(companyId, siteId, orgId);
        Map<String, Object> map = new HashMap<String, Object>();

        Integer point = pointDetailsMapper.queryPiont(accountId, type, companyId, siteId, null);
        if (null == point) {
            point = 0;
        }
        map.put("point", point);
        map.put("month", pointList);
        map.put("unit", unit);

        Map<String, Integer> pageMap = new HashMap<String, Integer>();
        pageMap.put("pageNo", pageNo);
        pageMap.put("pageSize", pageSize);
        pageMap.put("pageTotal", page.getTotal());

        Map<String, Object> resap = new HashMap<String, Object>();
        resap.put("listMap", map);
        resap.put("page", pageMap);
        return resap;
    }

    @Override
    public Integer queryPiont(Long userId, Long companyId, Long siteId, Long orgId) {

        return pointDetailsMapper.queryPiont(userId, null, companyId, siteId, orgId);

    }

    @Override
    public Page<PointDetailsVO> getManagePointDetails(Integer pageNo, Integer pageSize, Long activityId,
                                                      List<Long> accountIds, Date startTime, Date endTime, Long companyId, Long siteId) {
        Page<PointDetailsVO> page = new Page<PointDetailsVO>(pageNo, pageSize);
        List<PointDetailsVO> list = pointDetailsMapper.getManagePointDetails(page, activityId, accountIds, startTime, endTime, companyId, siteId);
        page.setRecords(list);
        return page;
    }

    @Override
    public boolean pointImport(List<PointImportVO> importVOList, Long companyId, Long siteId, Long orgId, Long accountId, String accountName) {
        // TODO("积分重构")
        if (!CollectionUtils.isEmpty(importVOList)) {
            List<com.yizhi.application.domain.PointDetails> pointDetailsList = new ArrayList<>();
            List<com.yizhi.application.domain.PointUser> pointUserInsertOrUpdateList = new ArrayList<>();
            com.yizhi.application.domain.PointDetails pointDetails = null;
            com.yizhi.application.domain.PointUser pointUser = null;
            boolean isOk = false;
            for (PointImportVO importVO : importVOList) {
                //新建积分详情对象,加入list
//                if (importVO.getPoint() == 0) {
//                    continue;
//          }
                Integer pointCount = getPointCountByAccountId(importVO.getAccountId(), companyId, siteId);//导入用户在point_detail的总积分
                pointDetails = new com.yizhi.application.domain.PointDetails();
                pointDetails.setId(idGenerator.generate());
                pointDetails.setAccountId(importVO.getAccountId());
                pointDetails.setTime(new Date());
                pointDetails.setCreateTime(new Date());
                pointDetails.setCreateById(accountId);
                pointDetails.setCreateByName(accountName);
                pointDetails.setLearnType("外部导入积分");
                pointDetails.setLearnName(importVO.getDescription());
                pointDetails.setLearnSource("外部导入");
                pointDetails.setState(1);
                pointDetails.setUpdateTime(new Date());
                pointDetails.setCompanyId(companyId);
                pointDetails.setSiteId(siteId);
                pointDetails.setOrgId(orgId);
                pointDetails.setMultiple(1);
                pointDetails.setLearnSourceId(Long.valueOf(0));

                //查询userpoint是否有数据,有记录加入积分更新入库,没有新建记录插入
                pointUser = new com.yizhi.application.domain.PointUser();
                pointUser.setUserId(importVO.getAccountId());
                pointUser.setCompanyId(companyId);
                pointUser.setSiteId(siteId);
                pointUser = pointUserMapper.selectOne(pointUser);
                if (null != pointUser) {
                    if (importVO.getPoint() < 0) {
                        if (pointUser.getTotalPoint() <= 0) {
                            continue;
                        }
                        if (pointUser.getTotalPoint() + importVO.getPoint() <= 0) {
                            pointDetails.setChangeBefore(pointCount);
                            pointDetails.setPoint(0 - pointUser.getTotalPoint());
                            pointDetails.setChangeAfter(pointCount - pointUser.getTotalPoint());
                            pointUser.setTotalPoint(0);
                        } else {
                            pointDetails.setChangeBefore(pointCount);
                            pointDetails.setPoint(importVO.getPoint());
                            pointDetails.setChangeAfter(pointCount + importVO.getPoint());
                            pointUser.setTotalPoint(pointUser.getTotalPoint() + importVO.getPoint());
                        }
                        pointDetailsList.add(pointDetails);

                    } else {
                        pointUser.setTotalPoint(pointUser.getTotalPoint() + importVO.getPoint());
                        pointDetails.setChangeBefore(pointCount);
                        pointDetails.setPoint(importVO.getPoint());
                        pointDetails.setChangeAfter(pointCount + importVO.getPoint());
                        pointDetailsList.add(pointDetails);
                    }
                    pointUser.setUpdateById(accountId);
                    pointUser.setUpdateTime(new Date());
                    pointUser.setUpdateByName(accountName);
                    pointUserInsertOrUpdateList.add(pointUser);
                } else {
                    if (importVO.getPoint() < 0) {
                        continue;
                    }
                    //用户没有积分设置0
                    pointDetails.setChangeBefore(0);
                    pointDetails.setPoint(importVO.getPoint());
                    pointDetails.setChangeAfter(importVO.getPoint());
                    pointDetailsList.add(pointDetails);

                    pointUser = new PointUser();
                    pointUser.setId(idGenerator.generate());
                    pointUser.setUserId(importVO.getAccountId());
                    pointUser.setTotalPoint(importVO.getPoint());
                    pointUser.setState(1);
                    pointUser.setCreateTime(new Date());
                    pointUser.setCreateById(accountId);
                    pointUser.setCreateByName(accountName);
                    pointUser.setCompanyId(companyId);
                    pointUser.setSiteId(siteId);
                    pointUser.setOrgId(orgId);
                    pointUserInsertOrUpdateList.add(pointUser);
                }
            }
            if (!CollectionUtils.isEmpty(pointDetailsList)) {
                isOk = this.insertBatch(pointDetailsList);
            }
            if (!CollectionUtils.isEmpty(pointUserInsertOrUpdateList)) {
                isOk = pointUserService.insertOrUpdateBatch(pointUserInsertOrUpdateList);
            }
            return isOk;
        }
        return true;
    }

    @Override
    public List<com.yizhi.application.domain.PointDetails> getReportPoints(Long bizId, Long accountId, Long companyId, Long siteId, boolean isRealTime) {
        return pointDetailsMapper.getReportPoints(bizId, accountId, companyId, siteId, isRealTime);
    }

    @Override
    public List<com.yizhi.application.domain.PointDetails> getCourseReportPoints(Long bizId, Long accountId, boolean isRealTime) {
        return pointDetailsMapper.getCourseReportPoints(bizId, accountId, isRealTime);
    }

    @Override
    public List<com.yizhi.application.domain.PointDetails> statisticsPoint() {
        // TODO Auto-generated method stub
        //第一步 先找到课程的数据
        List<com.yizhi.application.domain.PointDetails> listDate = new ArrayList<com.yizhi.application.domain.PointDetails>();
        List<PointDetails> listCoursePoint = pointDetailsMapper.getCourseStatisticsPoint();
		//List<PointDetails> listNoCoursePoint=pointDetailsMapper.getNoCourseStatisticsPoint();
        /*for (PointDetails pointDetails : listNoCoursePoint) {
            String learnType = pointDetails.getLearnType();
            switch (learnType.substring(0,2)){
                case "考试" :
                    learnType = "1";
                    break;
                case "学习" :
                    learnType = "7";
                    break;
                case "课程" :
                    learnType = "0";
                    break;
                default:
                    learnType = "-1";
            }
            pointDetails.setLearnType(learnType);
        }*/
        if (!CollectionUtils.isEmpty(listCoursePoint)) {
            listDate.addAll(listCoursePoint);
        }
		/*if(!CollectionUtils.isEmpty(listNoCoursePoint)) {
			listDate.addAll(listNoCoursePoint) ;
		}*/
        return listDate;
    }

    @Override
    public Integer getPointByCondition(Long accontId, Long siteId, List<Long> bizIds) {
        return this.baseMapper.getPointByCondition(accontId, siteId, bizIds);
    }

    @Override
    public Integer getPointCountByAccountId(Long accountId, Long companyId, Long siteId) {
        Integer count = 0;
        try {
            Integer pointCount = baseMapper.getPointCountByAccountId(accountId, companyId, siteId);

            if (pointCount != null) {
                count = pointCount;
            }
            return count;
        } catch (Exception e) {
            //查询表时结构未修改，先返回count = 0
            return 0;
        }
    }

    @Override
    public List<PointDetailsVo> syncPointDetails(Date startDate, Date endDate, Long companyId, Long siteId) {
        log.info("统计积分明细入参: startDate = {}, endDate = {}, companyId = {}, siteId = {} ",startDate,endDate,companyId,siteId);
        List<PointDetailsVo> list = new ArrayList<>();
        try {
            DateTime yesterday = DateUtil.yesterday();
            if (null == startDate){
                startDate = DateUtil.beginOfDay(yesterday);
            }
            if (null == endDate){
                endDate = DateUtil.endOfDay(yesterday);
            }
            list = pointDetailsMapper.selectPointDetails(startDate,endDate,companyId,siteId);
            if (null == list){
                return new ArrayList<>();
            }
            log.info("统计积分明细结果size={},请求参数: startDate = {}, endDate = {}, companyId = {}, siteId = {} ",list.size(),startDate,endDate,companyId,siteId);
            return list;
        }catch (Exception e){
            log.error("统计积分明细异常: 入参: startDate = {}, endDate = {}, companyId = {}, siteId = {} ",startDate,endDate,companyId,siteId,e);
        }
        return list;
    }

    @Override
    public PointDetailVO getPointDetail(Long accountId,Long siteId){
        PointDetailVO pointDetailVO = new PointDetailVO();
        List<String> pointTypeList = Lists.newArrayList();
        pointTypeList.add("登录");
        pointTypeList.add("阅读文章");
        pointTypeList.add("我要投稿");
        pointTypeList.add("发表评论");
        pointTypeList.add("参加活动");
        pointTypeList.add("培训测试");
        pointDetailVO.setPoint(0);
        String toDay = DateUtil.formatDate(new Date());
        Arrays.stream(PointChangeReasonConstant.values()).forEach(e->{
            if(pointTypeList.contains(e.getValue())){
                Integer point = pointDetailsMapper.selectPointVo(accountId,siteId,e.getKey(),toDay);
                Integer count = pointDetailsMapper.getCountToDay(accountId,siteId,e.getKey(),toDay);
                if(Objects.equals(e.getKey(),PointChangeReasonConstant.CREDITCOURSEDONE1.getKey())
                    ||Objects.equals(e.getKey(),PointChangeReasonConstant.CREDITEXAMPASSED.getKey())
                        ||Objects.equals(e.getKey(),PointChangeReasonConstant.CREDITCALENDARDONE.getKey())){

                }else if(Objects.equals(e.getKey(),PointChangeReasonConstant.CREDITEXAMDONE.getKey())
                        ||Objects.equals(e.getKey(),PointChangeReasonConstant.CREDITSIGNDONE.getKey())) {
                    pointDetailVO.addPoint(e.getKey(), e.getValue(),count,  0);
                }else{
                    pointDetailVO.addPoint(e.getKey(), e.getValue(),count, (point != null && point > 0) ? 1 : 0);
                }
                if(point!=null&&point>0){
                    pointDetailVO.setPoint(point+pointDetailVO.getPoint());
                }
            }
        });
        Integer point = pointDetailsMapper.getAmount(accountId,siteId);
        if(point!=null){
            pointDetailVO.setAmount(point.toString());
        }else{
            pointDetailVO.setAmount("0");
        }

        return pointDetailVO;
    }

    @Override
    public Integer getCountToDay(Long accountId,Long siteId,String type) {
        String toDay = DateUtil.formatDate(new Date());
        return pointDetailsMapper.getCountToDay(accountId,siteId,type,toDay);
    }

    @Override
    public List<PointDetailListVO> getPointDetailsList(Long accountId, Integer pageNo, Integer pageSize) {
        return pointDetailsMapper.getPointDetailsList(accountId, pageNo, pageSize);
    }

    public static void main(String[] args) {
        DateTime yesterday = DateUtil.yesterday();
        DateTime beginOfDay = DateUtil.beginOfDay(yesterday);
        DateTime endOfDay = DateUtil.endOfDay(yesterday);
        System.out.println(yesterday);
        System.out.println(beginOfDay);
        System.out.println(endOfDay);
    }
}
