package com.yizhi.application.controller;

import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.domain.PointProduct;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.orm.util.DomainConverter;
import com.yizhi.application.service.PointProductService;
import com.yizhi.point.application.vo.PointSearchParamVO;
import com.yizhi.point.application.vo.domain.PointProductVo;
import com.yizhi.util.application.json.JsonUtil;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Slf4j
@Api(tags = "积分兑换产品", description = "积分兑换产品 管理端")
@RestController
@RequestMapping("/manage/point/product")
public class PointProductController {

    private static final Logger LOG = LoggerFactory.getLogger(PointProductController.class);

    @Autowired
    PointProductService pointProductService;
    @Autowired
    IdGenerator idGenerator;
    @Autowired
    DomainConverter domainConverter;

    @PostMapping("/insert")
    Long insertDetail(@RequestBody PointProductVo pointProductVo) {
        if (null == pointProductVo) {
            return null;
        }
        PointProduct pointProduct = new PointProduct();
        BeanUtils.copyProperties(pointProductVo, pointProduct);
        return pointProductService.insertDetail(pointProduct);
    }

    @PostMapping("/update")
    Long updateById(@RequestBody PointProductVo pointProductVo) {
        if (null == pointProductVo) {
            return null;
        }

        PointProduct pointProduct = new PointProduct();;
        BeanUtils.copyProperties(pointProductVo, pointProduct);
        Boolean isOk = pointProductService.updateById(pointProduct);
        if (isOk) {
            return pointProductVo.getId();
        }
        return null;
    }

    @PostMapping("/delete")
    Long deleteDetailById(@RequestBody PointProductVo pointProductVo) {
        log.info("删除积分商品入参:{}", JSONUtil.toJsonStr(pointProductVo));
        if (null == pointProductVo) {
            return null;
        }
        PointProduct pointProduct = new PointProduct();
        BeanUtils.copyProperties(pointProductVo, pointProduct);
        log.info("删除积分商品拷贝后入参:{}", JSONUtil.toJsonStr(pointProductVo));
        Long i = pointProductService.deleteDetailById(pointProduct);

        return i;
    }

    @PostMapping("/enabled")
    Boolean bannerUp(@RequestBody PointProductVo pointProductVo) {
        if (null == pointProductVo) {
            return false;
        }
        PointProduct pointProduct = new PointProduct();
        BeanUtils.copyProperties(pointProductVo, pointProduct);
        return pointProductService.pointUp(pointProduct.getId(), pointProduct.getUpdateById(), pointProduct.getUpdateByName());
    }

    @PostMapping("/disabled")
    Boolean bannerDown(@RequestBody PointProductVo pointProductVo) {
        if (null == pointProductVo) {
            return false;
        }
        PointProduct pointProduct = new PointProduct();
        BeanUtils.copyProperties(pointProductVo, pointProduct);
        return pointProductService.pointDown(pointProduct.getId(), pointProduct.getUpdateById(), pointProduct.getUpdateByName());
    }

    @GetMapping("/list")
    public Page<PointProductVo> productList(@RequestBody PointSearchParamVO searchParamVO) {
        return pointProductService.productList(searchParamVO);
    }
}

