package com.yizhi.application.controller;

import com.yizhi.application.constant.PointTypeEnum;
import com.yizhi.application.domain.MqPointParam;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.redis.RedisUtils;
import com.yizhi.application.service.MqPointParamService;
import com.yizhi.application.service.PointService;
import com.yizhi.point.application.vo.PointParamVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Slf4j
@RestController
public class PointRedisController {
	
	@Autowired
	RedisUtils redisUtils;
	@Autowired
	private IdGenerator idGenerator;
	@Autowired
	private MqPointParamService mqPointParamService;
	@Autowired
	PointService pointService;

	@PostMapping("/point/redis/add")
	public String addPointRedis(@RequestBody PointParamVO vo) {
//		String key = idGenerator.generate().toString();
//		vo.setId(key);
//		boolean boo = redisUtils.set(key, vo, 10800L);
//		if(boo){
//			MqPointParam mqPointParam = new MqPointParam();
//			BeanUtils.copyProperties(vo, mqPointParam);
//			mqPointParam.setState(1);
//			mqPointParamService.insert(mqPointParam);
//			return key;
//		}
//		return null;
		return "";
	}


	@GetMapping("/point/add")
	public void pointAdd(
			@RequestParam(name = "type",required = false)String type,
			@RequestParam(name = "accountId",required = false)Long accountId,
			@RequestParam(name = "sourceId",required = false)String sourceId) {
		try {
			log.info("增加积分新接口入参 type:{}, accountId:{}, sourceId:{}", type, accountId, sourceId);
			pointService.addPoint(accountId, type, sourceId);
		} catch (Exception e) {
			e.printStackTrace();
			log.error("增加积分新接口发生异常:{}",e.getMessage());
		}
	}

}
