package com.yizhi.application.service.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.application.constant.PointTypeEnum;
import com.yizhi.application.domain.PointDetails;
import com.yizhi.application.domain.PointUser;
import com.yizhi.application.mapper.PointUserMapper;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.service.PointDetailsService;
import com.yizhi.application.service.PointUserService;
import com.yizhi.core.application.context.ContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.application.domain.Point;
import com.yizhi.application.mapper.PointMapper;
import com.yizhi.application.service.PointService;

/**
 * <p>
 * 积分设置 服务实现类
 * </p>
 *
 * @author bob123
 * @since 2018-04-20
 */
@Service
public class PointServiceImpl extends ServiceImpl<PointMapper, Point> implements PointService {
	
	@Autowired
	PointMapper pointMapper;
	@Autowired
	IdGenerator idGenerator;
	@Autowired
	PointDetailsService pointDetailsService;
	@Autowired
	PointUserService pointUserService;
	 
	@Override
	public Point pointList(Long companyId, Long siteId) {
		Point point = pointMapper.pointList(companyId, siteId);
		if(point == null){
			point = new Point();
			point.setState(0);
			point.setUnit("积分");
		}
		return point;
	}

	@Override
	public boolean updateList(Point point) {
		Integer state = point.getState(); 
		String unit = point.getUnit();
		Long companyId = point.getCompanyId();
		Long siteId = point.getSiteId();
		Long updateAccountId = point.getUpdateById();
		String updateAccountName = point.getUpdateByName();
		Integer count = pointMapper.updateList(state, unit, companyId, siteId, updateAccountId, updateAccountName);
		if(count > 0){
			return true;
		} else {
			point.setId(idGenerator.generate());
			point.setCreateById(updateAccountId);
			point.setCreateByName(updateAccountName);
			point.setCreateTime(new Date());
			count = pointMapper.insert(point);
			if(count > 0){
				return true;
			}
		}
		
		return false;
	}


	public void addPoint(Long accountId, String type, Long sourceId){
		Long companyId = ContextHolder.get().getCompanyId();
		Long orgId = ContextHolder.get().getOrgId();
		Long siteId = ContextHolder.get().getSiteId();
		String accountName = ContextHolder.get().getAccountName();
		//执行积分奖励策略进行相应的业务校验
		int point = getPointByType(type);
		if(point > 0) {
			PointUser pu = new PointUser();
			pu.setUserId(accountId);
			EntityWrapper<PointUser> wrapper = new EntityWrapper<PointUser>(pu);
			PointUser pointUser = pointUserService.selectOne(wrapper);
			Long id = idGenerator.generate();
			if (pu == null) {
				pu = new PointUser();
				pu.setId(id);
				pu.setUserId(accountId);
				pu.setTotalPoint(point);
				pu.setState(1);
				pu.setCreateById(accountId);
				pu.setCreateByName(accountName);
				pu.setCreateTime(new Date());
			} else {
				pu.setTotalPoint(pu.getTotalPoint() + point);
				pu.setUpdateById(accountId);
				pu.setUpdateByName(accountName);
				pu.setUpdateTime(new Date());
			}
			pu.setOrgId(orgId);
			pu.setSiteId(siteId);
			pu.setCompanyId(companyId);
			boolean b = pointUserService.insertOrUpdate(pu);
			if(b) {
				PointDetails pd = new PointDetails();
				pd.setId(idGenerator.generate());
				pd.setTime(new Date());
				pd.setChangeBefore(pointUser.getTotalPoint());
				pd.setPoint(point);
				pd.setChangeAfter(pointUser.getTotalPoint() + point);
				pd.setMultiple(1);
				pd.setAccountId(accountId);
				pd.setLearnName("积分兑换");
				pd.setLearnSource("积分兑换");
				pd.setLearnSourceId(sourceId);
				pd.setLearnType("积分兑换");
				pd.setState(1);
				pd.setCreateById(accountId);
				pd.setCreateByName(accountName);
				pd.setCreateTime(new Date());
				pd.setOrgId(orgId);
				pd.setCompanyId(companyId);
				pd.setSiteId(siteId);
				pointDetailsService.insert(pd);
			}
		}
	}

	public int getPointByType(String type){
		if(type.equals(PointTypeEnum.LOGIN.getKey())){
			return PointTypeEnum.LOGIN.getPoint();
		}
		if(type.equals(PointTypeEnum.READ.getKey())){
			return PointTypeEnum.READ.getPoint();
		}
		if(type.equals(PointTypeEnum.PUBLICATION.getKey())){
			return PointTypeEnum.PUBLICATION.getPoint();
		}
		if(type.equals(PointTypeEnum.COMMENT.getKey())){
			return PointTypeEnum.COMMENT.getPoint();
		}
		if(type.equals(PointTypeEnum.ACITVITY.getKey())){
			return PointTypeEnum.ACITVITY.getPoint();
		}
		if(type.equals(PointTypeEnum.EXAM.getKey())){
			return PointTypeEnum.EXAM.getPoint();
		}
		return 0;
	}
}
