package com.yizhi.application.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.application.domain.PointDetails;
import com.yizhi.application.domain.PointUser;
import com.yizhi.application.mapper.PointUserMapper;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.service.PointDetailsService;
import com.yizhi.application.service.PointLevelService;
import com.yizhi.application.service.PointUserService;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.point.application.vo.*;
import com.yizhi.system.application.constant.AuthzConstant;
import com.yizhi.system.application.system.remote.AccountClient;
import com.yizhi.system.application.system.remote.ReportClient;
import com.yizhi.system.application.vo.HQAccountInManageParam;
import com.yizhi.system.application.vo.ReportAccountRespInManageVO;
import com.yizhi.system.application.vo.ReportAccountRespVO;
import com.yizhi.system.application.vo.ReportRangeAccountReqVO;
import com.yizhi.util.application.date.DateUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * <p>
 * 学员积分 服务实现类
 * </p>
 *
 * @author bob123
 * @since 2018-04-20
 */
@Service
public class PointUserServiceImpl extends ServiceImpl<PointUserMapper, PointUser> implements PointUserService {

    private static final Logger LOGGER = LoggerFactory.getLogger(PointUserServiceImpl.class);

    @Autowired
    PointUserMapper pointUserMapper;
    @Autowired
    PointLevelService pointLevelService;
    @Autowired
    AccountClient accountClient;
    @Autowired
    ReportClient reportClient;
    @Autowired
    private IdGenerator idGenerator;
    @Autowired
    private PointDetailsService pointDetailsService;


    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    public Integer queryPiont(Long userId, Long companyId, Long siteId) {
        return pointUserMapper.queryPiont(userId, companyId, siteId);
    }

    @Override
    public Page<PointUserListVO> newUserRankList(PointUserParamVO vo) {
        Integer start =(vo.getPageNo()-1)*vo.getPageSize();
        Integer end=vo.getPageNo()*vo.getPageSize();
        Page<PointUserListVO> page = new Page<PointUserListVO>(vo.getPageNo(), vo.getPageSize());
        vo.setDateString(getDateString(vo.getDateType()));
        vo.setPageNo(start);
        vo.setPageSize(end);
        List<PointUserListVO> pointUserListVOS = pointUserMapper.getNewUserRankList(vo);
        Integer size = pointUserMapper.getNewUserRankCount(vo);
        page.setRecords(pointUserListVOS);
        page.setSize(size);
        return page;
    }

    @Override
    public Page<PointUserListVO> userRankList(PointUserParamVO vo) {


        Page<PointUserListVO> page = new Page<PointUserListVO>(vo.getPageNo(), vo.getPageSize());
        //根据 用户关键字 获取用户id 集合
        List<ReportAccountRespVO> accountVOList = null;
        boolean isGetAccount = true;
        if (vo.isAdmin()) {
            //管理员如果是模糊查询,查询用户,如果是所有用户,不查询
            if (StringUtils.isNotBlank(vo.getUserName()) || StringUtils.isNotBlank(vo.getOrgNameLike())) {
                isGetAccount = false;
                ReportRangeAccountReqVO reportRangeAccountReqVO = new ReportRangeAccountReqVO();
                reportRangeAccountReqVO.setSiteId(vo.getSiteId());
                if (StringUtils.isNotBlank(vo.getUserName())) {
                    reportRangeAccountReqVO.setAccountName(vo.getUserName().trim());
                }
                if (StringUtils.isNotBlank(vo.getOrgNameLike())) {
                    reportRangeAccountReqVO.setOrgName(vo.getOrgNameLike().trim());
                }
                accountVOList = reportClient.getRangeAccounts(reportRangeAccountReqVO);
                if (CollectionUtils.isEmpty(accountVOList)) {
                    return page;
                }
            }

        } else {
            isGetAccount = false;
            HQAccountInManageParam reportRangeAccountReqVO = new HQAccountInManageParam();
            reportRangeAccountReqVO.setAccountId(vo.getAccountId());
            reportRangeAccountReqVO.setSiteId(vo.getSiteId());
            reportRangeAccountReqVO.setModuleType(AuthzConstant.moduleType.statistics_point);
            if (StringUtils.isNotBlank(vo.getUserName())) {
                reportRangeAccountReqVO.setAccountName(vo.getUserName().trim());
            }
            if (StringUtils.isNotBlank(vo.getOrgNameLike())) {
                reportRangeAccountReqVO.setOrgName(vo.getOrgNameLike().trim());
            }
            ReportAccountRespInManageVO reportAccountRespInManageVO = reportClient.getRangeAccountsInManage(reportRangeAccountReqVO);
            if (null != reportAccountRespInManageVO) {
                if (!reportAccountRespInManageVO.getIsAdmin()) {
                    accountVOList = reportAccountRespInManageVO.getList();
                } else {
                    if (StringUtils.isNotBlank(vo.getUserName()) || StringUtils.isNotBlank(vo.getOrgNameLike())) {
                        isGetAccount = false;
                        ReportRangeAccountReqVO reportRangeAccountReqVO1 = new ReportRangeAccountReqVO();
                        reportRangeAccountReqVO1.setSiteId(vo.getSiteId());
                        if (StringUtils.isNotBlank(vo.getUserName())) {
                            reportRangeAccountReqVO1.setAccountName(vo.getUserName().trim());
                        }
                        if (StringUtils.isNotBlank(vo.getOrgNameLike())) {
                            reportRangeAccountReqVO1.setOrgName(vo.getOrgNameLike().trim());
                        }
                        accountVOList = reportClient.getRangeAccounts(reportRangeAccountReqVO1);
                        if (CollectionUtils.isEmpty(accountVOList)) {
                            return page;
                        }
                    }else {
                        isGetAccount = true;
                    }
                }
            }
        }

        Map<Long, ReportAccountRespVO> accountMap = new HashMap<>();
        List<Long> accountIds = new ArrayList<>();
        if (!CollectionUtils.isEmpty(accountVOList)) {
            for (ReportAccountRespVO reportAccountRespVO : accountVOList) {
                accountIds.add(reportAccountRespVO.getUserId());
                accountMap.put(reportAccountRespVO.getUserId(), reportAccountRespVO);
            }
        }

        if (!CollectionUtils.isEmpty(accountIds)) {
            vo.setAccountIds(accountIds);
        }


        List<PointUserListVO> list = pointUserMapper.userRankList(page, vo);
        if (CollectionUtils.isEmpty(list)) {
            return page;
        }

        //管理员非模糊查询根据记录用户id查找用户信息
        if (isGetAccount) {
            for (PointUserListVO pointUserListVO : list) {
                accountIds.add(pointUserListVO.getUserId());
            }
            if (CollectionUtils.isEmpty(accountIds)) {
                return page;
            }
            ReportRangeAccountReqVO reportRangeAccountReqVO = new ReportRangeAccountReqVO();
            reportRangeAccountReqVO.setSiteId(vo.getSiteId());
            reportRangeAccountReqVO.setAccountIds(accountIds);
            List<ReportAccountRespVO> respVOS = reportClient.getRangeAccounts(reportRangeAccountReqVO);
            if (!CollectionUtils.isEmpty(respVOS)) {
                for (ReportAccountRespVO respVO : respVOS) {
                    accountMap.put(respVO.getUserId(), respVO);
                }
            }
        }

        if (!CollectionUtils.isEmpty(list)) {
            for (PointUserListVO pvo : list) {
                Long userId = pvo.getUserId();
                if (userId == null) {
                    continue;
                }

                ReportAccountRespVO accountVO = accountMap.get(userId);

                if (accountVO != null) {
                    pvo.setUserName(accountVO.getUserName());
                    pvo.setEmail(accountVO.getEmail());
                    pvo.setName(accountVO.getUserFullName());
                    pvo.setOrgId(accountVO.getOrgId());
                    pvo.setOrgName(accountVO.getOrgName());
                    pvo.setAccountState(accountVO.getStatus() == 1 ? true : false);
                }
            }
            page.setRecords(list);
        }
        return page;
    }

    @Override
    public List<PointUserListVO> userRankListExport(PointUserParamVO vo) {
        return pointUserMapper.userRankList(vo);
    }

    @Override
    public Integer acquirePoint(Long accountId, Long learnSourceId, String createTime) {
        return pointUserMapper.acquirePoint(accountId, learnSourceId, createTime);
    }

    @Override
    public Timestamp getStartDate() {
        return pointUserMapper.getStartDate();
    }

	@Override
	public Map<Long, Long> totalPoint( List<Long> siteIds, String startDate, String endDate) {
		// TODO Auto-generated method stub
		Map<Long, Long> hashMap = new HashMap<Long, Long>();
		List<TotalPointVO> list = pointUserMapper.totalPoint(siteIds, startDate, endDate);
		for(TotalPointVO vo:list) {
			if (vo.getAccountId()!=null) {
				hashMap.put(vo.getAccountId(), vo.getPoint());
			}
		}
		return hashMap;
	}

    public String getDateString(Integer dateType) {
        String dateString = DateUtil.toDay(new Date());
        String[] dateArrays = dateString.split("-");
        if(Objects.equals(dateType,1)){
            dateString = dateArrays[0];
        }
        if(Objects.equals(dateType,2)){
            dateString = dateArrays[0]+"-"+dateArrays[1];
        }
        if(Objects.equals(dateType,4)){
            Calendar calendar = Calendar.getInstance();
            int week = calendar.get(Calendar.WEEK_OF_YEAR);
            if(week==1){
                dateString = String.valueOf(Integer.valueOf(dateArrays[0])-1);
            }else{
                dateString = dateArrays[0];
            }
        }
        return dateString;
    }


    public Page<PointUserPageListVO> list(PointSearchParamVO searchParamVO) {
        Page<PointUserPageListVO> page = new Page<>(searchParamVO.getPageNo(), searchParamVO.getPageSize());
        List pointUserList = pointUserMapper.list(page, searchParamVO.getName());
        page.setRecords(pointUserList);
        return page;
    }

    public int updateUserPointExchange(PointUserExchangeVO pointUserExchangeVO) {
        PointUser pu = new PointUser();
        pu.setUserId(pointUserExchangeVO.getUserId());
        EntityWrapper<PointUser> wrapper = new EntityWrapper<PointUser>(pu);
        PointUser pointUser = this.selectOne(wrapper);
        if(pointUser == null) {
            return 0;
        }
        Long companyId = ContextHolder.get().getCompanyId();
        Long orgId = ContextHolder.get().getOrgId();
        Long siteId = ContextHolder.get().getSiteId();
        Long accountId = ContextHolder.get().getAccountId();
        String accountName = ContextHolder.get().getAccountName();
        PointDetails pd = new PointDetails();
        pd.setId(idGenerator.generate());
        pd.setTime(new Date());
        pd.setChangeBefore(pointUserExchangeVO.getPoint());
        pd.setPoint(pointUserExchangeVO.getPoint());
        pd.setChangeAfter(pointUser.getTotalPoint() - pointUserExchangeVO.getPoint());
        pd.setMultiple(1);
        pd.setAccountId(accountId);
        pd.setLearnName("积分兑换");
        pd.setLearnSource("积分兑换");
        pd.setLearnSourceId(0L);
        pd.setLearnType("积分兑换");
        pd.setState(1);
        pd.setCreateById(accountId);
        pd.setCreateByName(accountName);
        pd.setCreateTime(new Date());
        pd.setOrgId(orgId);
        pd.setCompanyId(companyId);
        pd.setSiteId(siteId);
        pointDetailsService.insert(pd);
        return pointUserMapper.updateUserPointExchange(pointUserExchangeVO);
    }


}
