
/* 11:45:41 AM yz-dev-- cloud_point */ ALTER TABLE `point_details`
ADD `change_before` INT(11)  NULL  DEFAULT NULL COMMENT '变动前积分总量' AFTER `time`,
ADD `change_after` INT(11)  NULL  DEFAULT NULL  COMMENT '变动后积分总量'  AFTER `point`,
CHANGE `update_time` `update_time` TIMESTAMP  NOT NULL  DEFAULT CURRENT_TIMESTAMP  ON UPDATE CURRENT_TIMESTAMP  COMMENT '修改时间';

UPDATE point_details c
LEFT JOIN (
	SELECT
		d1.id as id,
		sum(d2.point) as sum_of_point
	FROM
		point_details d1
		LEFT JOIN
		point_details d2
		ON d1.account_id = d2.account_id
		and d1.site_id = d2.site_id
		and d1.company_id = d2.company_id
	WHERE
		 d1.id >= d2.id
	GROUP BY
		d1.account_id,
		d1.company_id,
		d1.site_id,
		d1.id) AS d ON c.id = d.id
SET c.change_after = d.sum_of_point;

update point_details set change_before = change_after - point;


#报表数据库cloud_statistics新建积分日志表point_log
CREATE TABLE `point_log` (
                             `id` bigint(20) NOT NULL COMMENT '主键Id',
                             `point_detail_id` bigint(20) DEFAULT NULL COMMENT '积分记录ID',
                             `account_id` bigint(20) DEFAULT NULL COMMENT '学员Id',
                             `before_count` int(11) DEFAULT NULL COMMENT '变动前数量',
                             `change_count` int(10) DEFAULT NULL COMMENT '变动数量',
                             `after_count` int(11) DEFAULT NULL COMMENT '变动后数量',
                             `change_type` int(11) DEFAULT NULL COMMENT '变动类型',
                             `relation_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL COMMENT '变动原因（考试名或项目名）',
                             `create_by_id` bigint(20) DEFAULT NULL COMMENT '创建人',
                             `create_by_name` varchar(200) DEFAULT NULL COMMENT '创建人姓名',
                             `company_id` bigint(20) DEFAULT NULL COMMENT '公司ID',
                             `org_id` bigint(20) DEFAULT NULL COMMENT '部门ID',
                             `site_id` bigint(20) DEFAULT NULL COMMENT '站点ID',
                             `created_at` timestamp NULL DEFAULT NULL COMMENT 'log创建时间',
                             `log_created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'point_details表跑批记录入库时间',
                             UNIQUE KEY `index_id` (`id`) USING BTREE,
                             KEY `index_account_site_company_id` (`account_id`,`site_id`,`company_id`) USING BTREE,
                             KEY `index_created_at` (`created_at`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='积分明细';