package com.yizhi.point.application.feign;

import com.yizhi.point.application.vo.PointDetailVO;
import com.yizhi.point.application.vo.domain.PointDetailsVo;
import com.yizhi.point.application.vo.PointImportVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 轮播
 *
 * @author HUIHUI.DUAN
 * @date 2018/3/28 10:44
 */
@FeignClient(name = "point", contextId = "PointDetailsFeignClients")
public interface PointDetailsFeignClients {

    @GetMapping("/api/point/detail/pointList")
    Map<String, Object> pointList(@RequestParam("year") String year,
                                  @RequestParam(value = "type", required = false) String type,
                                  @RequestParam("accountId") Long accountId,
                                  @RequestParam("pageNo") Integer pageNo, @RequestParam("pageSize") Integer pageSize, @RequestParam("companyId") Long companyId,
                                  @RequestParam("siteId") Long siteId, @RequestParam("orgId") Long orgId);


    @GetMapping("/api/point/detail/getPointDetail")
    PointDetailVO getPointDetail(@RequestParam("accountId") Long accountId,
                                        @RequestParam("siteId") Long siteId);

    @GetMapping("/api/point/detail/countList")
    Integer queryPiont(@RequestParam("userId") Long userId, @RequestParam(value = "companyId", required = false) Long companyId,
                       @RequestParam("siteId") Long siteId, @RequestParam(name = "orgId", required = false) Long orgId);

    /**
     * 外部积分导入
     *
     * @param importVOList
     * @return
     */
    @PostMapping("/api/point/detail/pointImport")
    boolean insertExternalPoint(@RequestBody List<PointImportVO> importVOList,
                                @RequestParam("companyId") Long companyId,
                                @RequestParam("siteId") Long siteId,
                                @RequestParam("orgId") Long orgId,
                                @RequestParam("accountId") Long accountId,
                                @RequestParam("accountName") String accountName);


    /**
     * 报表跑批积分
     *
     * @return
     */
    @GetMapping("/api/point/detail/statisticsPoint")
    List<PointDetailsVo> statisticsPoint();

    /**
     * 根据传入的accountID  siteId   活动id 求得积分总和
     *
     * @param accountId
     * @param siteId
     * @param bizIds
     * @return
     */

    @GetMapping("/api/point/detail/getPointByCondition")
    public Integer getPointByCondition(@RequestParam("accountId") Long accountId,
                                       @RequestParam("siteId") Long siteId,
                                       @RequestParam("bizIds") List<Long> bizIds);

    /**
     * 统计积分明细
     */
    @GetMapping("/api/point/detail/sync/list")
    List<PointDetailsVo> syncPointDetails(@RequestParam(name = "startDate",required = false) String startDate,
                                                 @RequestParam(name = "endDate",required = false) String endDate ,
                                                 @RequestParam(name = "companyId",required = false) Long companyId ,
                                                 @RequestParam(name = "siteId",required = false) Long siteId
    );
}
