package com.yizhi.point.application.vo.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;


@Data
@ApiModel(value = "PointExchangeApplyVo", description = "兑换申请")
@TableName("point_exchange_apply")
public class PointExchangeApplyVo extends Model<PointExchangeApplyVo> {

    private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "user_id")
    private Long userId;

	@ApiModelProperty(value = "产品ids")
    @TableField("product_ids")
    private String productIds;

	@ApiModelProperty(value = "0-待审核,1-通过,2-驳回")
    private Integer state;

	@ApiModelProperty(value = "创建时间")
    @TableField("create_time")
    private Date createTime;

	@ApiModelProperty(value = "修改时间")
    @TableField("update_time")
    private Date updateTime;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }
}
