package com.yizhi.point.application.vo.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 活动策略
 * </p>
 *
 * @author bob123
 * @since 2018-04-20
 */
@Data
@ApiModel(value = "PointProductVo", description = "积分兑换商品配置")
@TableName("point_product")
public class PointProductVo extends Model<PointProductVo> {

    private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "产品id")
    private Long id;

	@ApiModelProperty(value = "产品名称")
    @TableField("product_name")
    private String productName;

    @ApiModelProperty(value = "产品图片")
    @TableField("product_img")
    private String productImg;

    @ApiModelProperty(value = "所需积分")
    @TableField("point")
    private int point;

	@ApiModelProperty(value = "0删除 1上架 2下架")
    private Integer state;

    @ApiModelProperty(value = "兑换开始时间")
    @TableField("startTime")
    private Date startTime;

    @ApiModelProperty(value = "兑换结束时间")
    @TableField("endTime")
    private Date endTime;

	@ApiModelProperty(value = "创建时间")
    @TableField("create_time")
    private Date createTime;

	@ApiModelProperty(value = "创建人")
    @TableField("create_by_id")
    private Long createById;

	@ApiModelProperty(value = "创建人姓名")
    @TableField("create_by_name")
    private String createByName;

	@ApiModelProperty(value = "修改时间")
    @TableField("update_time")
    private Date updateTime;

	@ApiModelProperty(value = "修改人")
    @TableField("update_by_id")
    private Long updateById;

	@ApiModelProperty(value = "修改人姓名")
    @TableField("update_by_name")
    private String updateByName;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }
}
