package com.yizhi.application.controller;


import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.yizhi.application.domain.Point;
import com.yizhi.application.service.PointDetailsService;
import com.yizhi.application.service.PointService;
import com.yizhi.point.application.vo.PointDetailsVO;
import com.yizhi.point.application.vo.domain.PointVo;
import com.yizhi.system.application.system.remote.AccountClient;
import com.yizhi.system.application.vo.AccountVO;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.baomidou.mybatisplus.plugins.Page;

import io.swagger.annotations.Api;

/**
 * <p>
 * 积分设置 前端控制器
 * </p>
 *
 * @author bob123
 * @since 2018-04-20
 */
@Api(tags="积分 管理端", description="积分 管理端")
@RestController
@RequestMapping("/manage/point")
public class PointController {
	
	private static final Logger LOG = LoggerFactory.getLogger(PointController.class);
	
	@Autowired
	PointService pointService;
	
	@Autowired
	PointDetailsService pointDetailsService;
	
	@Autowired
	AccountClient accountClient;
	
	@GetMapping("/strategy/view")
	public PointVo pointList(@RequestParam(name = "companyId",required = false)Long companyId,
							 @RequestParam(name = "siteId",required = false) Long siteId){

		Point point = pointService.pointList(companyId, siteId);
		PointVo point1 = new PointVo();
		BeanUtils.copyProperties(point, point1);
		return point1;
	}
	
	@PostMapping("/strategy/update")
	public boolean pointList(@RequestBody Point point){
		return pointService.updateList(point);
	}

	@GetMapping("/update/after")
	public void updatePointDetailsChangeAfter(
			@RequestParam(name = "siteId" ,required = false ) Long siteId,
			@RequestParam(name = "accountId" ,required = false ) Long accountId) {
		pointDetailsService.updateChangeAfter(accountId,siteId);
	}

	/**
	 * 管理台查询指定用户，指定类型积分明细
	 * @param learnType
	 * @param accountName
	 * @param startTime
	 * @param endTime
	 * @param pageNo
	 * @param pageSize
	 * @param companyId
	 * @param siteId
	 * @return
	 */
	@GetMapping("/details/list")
	Page<PointDetailsVO> getManagePointDetails(
			@RequestParam(name = "learnType", required = false) String learnType,
			@RequestParam(name = "accountName", required = false) String accountName, 
			@RequestParam(name = "startTime", required = false) Long startTime,
			@RequestParam(name = "endTime", required = false) Long endTime,
			@RequestParam(name = "pageNo", required = false) Integer pageNo,
			@RequestParam(name = "pageSize", required = false) Integer pageSize,
			@RequestParam(name = "companyId", required = false) Long companyId,
			@RequestParam(name = "siteId", required = false) Long siteId){
		
		List<Long> accountIds = new ArrayList<Long>();
		try{
			if(!StringUtils.isBlank(accountName)){
				List<AccountVO> accountVOs = accountClient.fuzzySearchAccountByName(accountName, companyId);
				if(accountVOs == null || accountVOs.size() == 0){
					LOG.info("积分服务获取用户调用：AccountClient.fuzzySearchAccountByName 搜索不到 " + accountName + "的用户信息"); 
				}
				for(AccountVO item : accountVOs){
					accountIds.add(item.getId());
				}
			}			
		} catch(Exception e){
			LOG.error("积分服务获取用户调用：AccountClient.fuzzySearchAccountByName错误" + e.getMessage()); 
			e.printStackTrace();
		}
		Page<PointDetailsVO> page = null;
		if((accountIds != null && accountIds.size() > 0) || StringUtils.isBlank(accountName)){
            Date startDate = null;
            if (null != startTime) {
                startDate = new Date(startTime);
            }
            Date endDate = null;
            if (null != endTime) {
                endDate = new Date(endTime);
            }
			page = pointDetailsService.getManagePointDetails(pageNo, pageSize, learnType, accountIds,
                    startDate, endDate, companyId, siteId);
			List<PointDetailsVO> dtlIds = page.getRecords();
			
			AccountVO accountVO = null;
			String name = "";
			for(PointDetailsVO dtl : dtlIds){
				try{
					accountVO = accountClient.findById(Long.valueOf(dtl.getAccountId()));
					name = accountVO.getName();
				} catch(Exception e){
					LOG.info("积分服务获取用户信息报错：" + e.getMessage());
					name = "--";
					e.printStackTrace();
				}			
				dtl.setAccountName(name);
			}
		} else {
			page = new Page<PointDetailsVO>(pageNo, pageSize);
			page.setTotal(0);
		}
		return page;
	}


}

