package com.yizhi.point.application.feign;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.point.application.vo.domain.MqPointParamVo;
import com.yizhi.point.application.vo.domain.PointActivityVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * 轮播
 *
 * @author HUIHUI.DUAN
 * @date 2018/3/28 10:44
 */
@FeignClient(name = "point", contextId = "PointActivityFeignClients")
public interface PointActivityFeignClients {

    @PostMapping("/manage/activity/insert")
    Long insertDetail(@RequestBody PointActivityVo pointActivityVo);

    @PostMapping("/manage/activity/delete")
    Long deleteDetailById(@RequestBody PointActivityVo pointActivityVo);

    @PostMapping("/manage/activity/update")
    Long updateById(@RequestBody PointActivityVo pointActivityVo);

    @PostMapping("/manage/activity/enabled")
    Boolean pointUp(@RequestBody PointActivityVo pointActivityVo);

    @PostMapping("/manage/activity/disabled")
    Boolean pointDown(@RequestBody PointActivityVo pointActivityVo);

    @GetMapping("/manage/activity/list")
    Page<PointActivityVo> activityList(@RequestParam Map<String, Object> map);

    @GetMapping("/manage/activity/byCode")
    PointActivityVo getActivity(@RequestParam("code") String code);

    @GetMapping("/manage/activity/getPointRecords")
    List<MqPointParamVo> getPointRecords(@RequestParam("eventName") String eventName,
                                         @RequestParam("activityId") Long activityId,
                                         @RequestParam("companyId,") Long companyId,
                                         @RequestParam("siteId") Long siteId);
}
