package com.yizhi.point.application.vo;

import com.baomidou.mybatisplus.annotations.TableField;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * com.yizhi.point.application.vo
 *
 * @author yanglang
 * @create 2025-03-10 10:35:16
 */
@Data
public class PointDetailVO {

    @ApiModelProperty(value = "积分")
    private Integer point;

    @ApiModelProperty(value = "当前积分的总量")
    private String amount;

    @ApiModelProperty(value = "积分活动分类")
    private List<PointVo> pointVoList;

    public void addPoint(String learnType,String learnName,Integer countNum,Integer flag){
        PointVo pointVo = new PointVo();
        pointVo.setFlag(flag);
        pointVo.setCountNum(countNum);
        pointVo.setLearnName(learnName);
        pointVo.setLearnType(learnType);
        if(CollectionUtils.isEmpty(this.pointVoList)){
            this.pointVoList = Lists.newArrayList();
        }
            this.pointVoList.add(pointVo);
    }
}
