package com.yizhi.application.service.impl;

import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.application.constant.PointTypeEnum;
import com.yizhi.application.domain.Point;
import com.yizhi.application.domain.PointDetails;
import com.yizhi.application.domain.PointTypeStrategy;
import com.yizhi.application.domain.PointUser;
import com.yizhi.application.mapper.PointMapper;
import com.yizhi.application.mapper.PointProductMapper;
import com.yizhi.application.mapper.PointUserMapper;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.service.PointDetailsService;
import com.yizhi.application.service.PointService;
import com.yizhi.application.service.PointUserService;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.point.application.vo.PointDetailListVO;
import com.yizhi.point.application.vo.PointUserExchangeVO;
import com.yizhi.util.application.date.DateUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 积分设置 服务实现类
 * </p>
 *
 * @author bob123
 * @since 2018-04-20
 */
@Slf4j
@Service
public class PointServiceImpl extends ServiceImpl<PointMapper, Point> implements PointService {
	
	@Autowired
	PointMapper pointMapper;
	@Autowired
	IdGenerator idGenerator;
	@Autowired
	PointDetailsService pointDetailsService;
	@Autowired
	PointUserService pointUserService;
    @Autowired
    private PointUserMapper pointUserMapper;
	@Autowired
	private PointProductMapper pointProductMapper;

	@Override
	public Point pointList(Long companyId, Long siteId) {
		Point point = pointMapper.pointList(companyId, siteId);
		if(point == null){
			point = new Point();
			point.setState(0);
			point.setUnit("积分");
		}
		return point;
	}

	@Override
	public boolean updateList(Point point) {
		Integer state = point.getState(); 
		String unit = point.getUnit();
		Long companyId = point.getCompanyId();
		Long siteId = point.getSiteId();
		Long updateAccountId = point.getUpdateById();
		String updateAccountName = point.getUpdateByName();
		Integer count = pointMapper.updateList(state, unit, companyId, siteId, updateAccountId, updateAccountName);
		if(count > 0){
			return true;
		} else {
			point.setId(idGenerator.generate());
			point.setCreateById(updateAccountId);
			point.setCreateByName(updateAccountName);
			point.setCreateTime(new Date());
			count = pointMapper.insert(point);
			if(count > 0){
				return true;
			}
		}
		
		return false;
	}


	public void addPoint(Long accountId, String type, String sourceId){
		Long companyId = ContextHolder.get().getCompanyId();
		Long orgId = ContextHolder.get().getOrgId();
		Long siteId = ContextHolder.get().getSiteId();
		String accountName = ContextHolder.get().getAccountName();
		//执行积分奖励策略进行相应的业务校验
		PointTypeStrategy strategy = getPointByType(type, accountId);
		log.info("获取赠送积分策略:{}", JSONUtil.toJsonStr(strategy));
		if(strategy != null) {
			PointUser pu = new PointUser();
			pu.setUserId(accountId);
			EntityWrapper<PointUser> wrapper = new EntityWrapper<PointUser>(pu);
			pu = pointUserService.selectOne(wrapper);
			Long id = idGenerator.generate();
			if (pu == null) {
				pu = new PointUser();
				pu.setId(id);
				pu.setUserId(accountId);
				pu.setTotalPoint(strategy.getPointTypeEnum().getPoint());
				pu.setState(1);
				pu.setCreateById(accountId);
				pu.setCreateByName(accountName);
				pu.setCreateTime(new Date());
			} else {
				pu.setTotalPoint(pu.getTotalPoint() + strategy.getPointTypeEnum().getPoint());
				pu.setUpdateById(accountId);
				pu.setUpdateByName(accountName);
				pu.setUpdateTime(new Date());
			}
			pu.setOrgId(orgId);
			pu.setSiteId(siteId);
			pu.setCompanyId(companyId);
			boolean b = pointUserService.insertOrUpdate(pu);
			if(b) {
				PointDetails pd = new PointDetails();
				pd.setId(idGenerator.generate());
				pd.setTime(new Date());
				pd.setChangeBefore(pu.getTotalPoint());
				pd.setPoint(strategy.getPointTypeEnum().getPoint());
				pd.setChangeAfter(pu.getTotalPoint() + strategy.getPointTypeEnum().getPoint());
				pd.setMultiple(1);
				pd.setAccountId(accountId);
				pd.setLearnName(strategy.getPointTypeEnum().getDesc());
				pd.setLearnSource(strategy.getLearnSource());
				pd.setLearnType(strategy.getPointTypeEnum().getKey());
				pd.setState(1);
				pd.setCreateById(accountId);
				pd.setCreateByName(accountName);
				pd.setCreateTime(new Date());
				pd.setOrgId(orgId);
				pd.setCompanyId(companyId);
				pd.setSiteId(siteId);
				pointDetailsService.insert(pd);
			}
		}
	}

	public PointTypeStrategy getPointByType(String type, Long accountId){
		PointTypeStrategy strategy = null;
		if(type.equals(PointTypeEnum.LOGIN.getKey())){
			//查询当天是否首次登录，奖励积分
			String date = DateUtil.format(new Date(), "yyyy-MM-dd");
			PointDetails pd = new PointDetails();
			pd.setAccountId(accountId);
			pd.setLearnType(PointTypeEnum.LOGIN.getKey());
			pd.setLearnSource(date);
			EntityWrapper<PointDetails> wrapper = new EntityWrapper<PointDetails>(pd);
			int cnt = pointDetailsService.selectCount(wrapper);
			log.info("赠送积分判断是否为首次登录:{}", cnt);
			if(cnt <= 0) {
				return new PointTypeStrategy(PointTypeEnum.LOGIN, date);
			}
		}
		if(type.equals(PointTypeEnum.READ.getKey())){
			return null;
		}
		if(type.equals(PointTypeEnum.PUBLICATION.getKey())){
			return null;
		}
		if(type.equals(PointTypeEnum.COMMENT.getKey())){
			return null;
		}
		if(type.equals(PointTypeEnum.ACITVITY.getKey())){
			return null;
		}
		if(type.equals(PointTypeEnum.EXAM.getKey())){
			return null;
		}
		return null;
	}

	public boolean exchange(Long companyId, Long orgId, Long siteId, Long accountId, String accountName, String productIds){
		log.info("积分兑换入参 accountId:{}, productIds:{}", accountId, productIds);
		//查询本次积分兑换需要扣减的积分
		Integer point = pointProductMapper.getSumPointByProductId(Arrays.asList(productIds.split(",")));
		log.info("积分兑换扣减积分 point:{}", point);
		PointUser pu = new PointUser();
		pu.setUserId(accountId);
		EntityWrapper<PointUser> wrapper = new EntityWrapper<PointUser>(pu);
		PointUser pointUser = pointUserService.selectOne(wrapper);
		if(pointUser == null) {
			return false;
		}
		PointDetails pd = new PointDetails();
		pd.setId(idGenerator.generate());
		pd.setTime(new Date());
		pd.setChangeBefore(pointUser.getTotalPoint());
		pd.setPoint(point * -1);
		pd.setChangeAfter(pointUser.getTotalPoint() - point);
		pd.setMultiple(1);
		pd.setAccountId(accountId);
		pd.setLearnName(PointTypeEnum.EXCHANGE.getDesc());
		pd.setLearnSource(productIds);
		pd.setLearnSourceId(0L);
		pd.setLearnType(PointTypeEnum.EXCHANGE.getKey());
		pd.setState(1);
		pd.setCreateById(accountId);
		pd.setCreateByName(accountName);
		pd.setCreateTime(new Date());
		pd.setOrgId(orgId);
		pd.setCompanyId(companyId);
		pd.setSiteId(siteId);
		pointDetailsService.insert(pd);
		PointUserExchangeVO pointUserExchangeVO = new PointUserExchangeVO();
		pointUserExchangeVO.setUserId(accountId);
		pointUserExchangeVO.setPoint(point);
		int ret = pointUserMapper.updateUserPointExchange(pointUserExchangeVO);
		return ret > 0;
	}

	public List<PointDetailListVO> getPointDetailsList(Long accountId, Integer pageNo, Integer pageSize) {
		pageNo = (pageNo - 1) * pageSize;
		return pointDetailsService.getPointDetailsList(accountId, pageNo, pageSize);
	}

}
