package com.yizhi.point.application.feign;

import com.yizhi.point.application.vo.domain.PointLevelVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 轮播
 * @author HUIHUI.DUAN
 * @date 2018/3/28 10:44
 */
@FeignClient(name = "point", contextId = "PointLevelFeignClients")
public interface PointLevelFeignClients {
	
	@PostMapping("/manage/point/level/insert")
	Boolean inserts(@RequestBody PointLevelVo pointLevel);
	
	@PostMapping("/manage/point/level/delete")
	Boolean piontLevelDelete(@RequestParam("id") Long id);
	
	@GetMapping("/manage/point/level/list")
	List<PointLevelVo> levelList(@RequestParam("id") Long id);
	
	@GetMapping("/manage/point/level/update")
	Integer updateById1(@RequestBody PointLevelVo pointLevel);
}
