package com.yizhi.application.controller;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.domain.PointDetails;
import com.yizhi.application.service.PointDetailsService;
import com.yizhi.application.service.PointUserService;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.point.application.vo.*;
import com.yizhi.point.application.vo.domain.PointDetailsVo;
import com.yizhi.system.application.system.remote.ReportClient;
import io.swagger.annotations.Api;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 学员积分 前端控制器
 * </p>
 *
 * @author bob123
 * @since 2018-04-20
 */
@Api(tags = "学员积分 管理端", description = "学员积分 管理端")
@RestController
@RequestMapping("/manage/point/user")
public class PointUserController {

    @Autowired
    PointUserService pointUserService;
    @Autowired
    PointDetailsService pointDetailsService;
    @Autowired
    ReportClient reportClient;
    @GetMapping("/countList")
    public Integer queryPiont(@RequestParam(name = "userId", required = false) Long userId) {
        RequestContext res = ContextHolder.get();
        return pointUserService.queryPiont(userId, res.getCompanyId(), res.getSiteId());
    }

    @GetMapping("/rank/list")
    public Page<PointUserListVO> userRankList(@RequestBody PointUserParamVO vo) {
        return pointUserService.userRankList(vo);
    }


    @GetMapping("/new/rank/list")
    public Page<PointUserListVO> newUserRankList(@RequestBody PointUserParamVO vo) {
        return pointUserService.newUserRankList(vo);
    }

    @GetMapping("/rank/list/export")
    public List<PointUserListVO> userRankListExport(@RequestBody PointUserParamVO vo) {
        return pointUserService.userRankListExport(vo);
    }

    @GetMapping("/rank/list/startDate")
    public Timestamp getStartDate() {
        return pointUserService.getStartDate();
    }

    @GetMapping("/point/acquire")
    public Integer acquirePoint(@RequestParam(name = "accountId", required = true) Long accountId,
                                @RequestParam(name = "learnSourceId", required = true) Long learnSourceId,
                                @RequestParam(name = "createTime", required = true) String createTime) {
        return pointUserService.acquirePoint(accountId, learnSourceId, createTime);

    }

    @GetMapping("/point/isHasPoint")
    public boolean isHasPoint(@RequestParam("bizId") Long bizId, @RequestParam("accountId") Long accountId) {
        com.yizhi.application.domain.PointDetails pointDetails = new com.yizhi.application.domain.PointDetails();
        pointDetails.setLearnSourceId(bizId);
        pointDetails.setAccountId(accountId);
        pointDetails.setState(1);
        List<com.yizhi.application.domain.PointDetails> pointDetailsList = pointDetailsService.selectList(new EntityWrapper<>(pointDetails));
        if (CollectionUtils.isNotEmpty(pointDetailsList)) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * 报表获取业务积分记录,可获取所有,可根据业务id,accountId
     *
     * @param bizId
     * @param accountId
     * @param companyId
     * @param siteId
     * @return
     */
    @GetMapping("/getReportPoints")
    public List<PointDetailsVo> getReportPoints(@RequestParam(value = "bizId", required = false) Long bizId, @RequestParam(value = "accountId", required = false) Long accountId,
                                                @RequestParam(value = "companyId", required = false) Long companyId, @RequestParam(value = "siteId", required = false) Long siteId,
                                                @RequestParam(value = "isRealTime", required = true) boolean isRealTime) {
        List<PointDetailsVo> pointDetailsVo2 = new ArrayList<>();
        List<PointDetails> reportPoints = pointDetailsService.getReportPoints(bizId, accountId, companyId, siteId, isRealTime);
        for (PointDetails d:reportPoints
             ) {
            PointDetailsVo p=new PointDetailsVo();
            BeanUtils.copyProperties(d,p);
            pointDetailsVo2.add(p);
        }
        return pointDetailsVo2;
    }

    /**
     * 报表获取业务积分记录,可获取所有,可根据业务id,accountId
     *
     * @param bizId
     * @param accountId
     * @param isRealTime
     * @return
     */
    @GetMapping("/getCourseReportPoints")
    public List<PointDetailsVo> getCourseReportPoints(@RequestParam(value = "bizId", required = false) Long bizId, @RequestParam(value = "accountId", required = false) Long accountId,
                                                      @RequestParam(value = "isRealTime", required = true) boolean isRealTime) {
        List<PointDetails> courseReportPoints = pointDetailsService.getCourseReportPoints(bizId, accountId, isRealTime);
        List<PointDetailsVo> pointDetailsVo2 = new ArrayList<>();;
        for (PointDetails d:courseReportPoints
        ) {
            PointDetailsVo p=new PointDetailsVo();
            BeanUtils.copyProperties(d,p);
            pointDetailsVo2.add(p);
        }
        return pointDetailsVo2;
    }
    
    @GetMapping("/totalPoint")
    public Map<Long, Long> totalPoint( @RequestParam("siteIds") List<Long> siteIds,
			@RequestParam("startDate") String startDate, @RequestParam("endDate") String endDate) {
				return pointUserService.totalPoint(siteIds, startDate, endDate);
    	
    }

    @GetMapping("/list")
    public Page<PointUserPageListVO> list(@RequestBody PointSearchParamVO searchParamVO) {
        return pointUserService.list(searchParamVO);
    }

    @GetMapping("/exchange")
    public int exchange(@RequestBody PointUserExchangeVO pointUserExchangeVO) {
        return pointUserService.updateUserPointExchange(pointUserExchangeVO);
    }
}
