package com.yizhi.application.mapper;

import java.sql.Timestamp;
import java.util.List;

import com.yizhi.application.domain.PointProduct;
import com.yizhi.application.domain.PointUser;
import com.yizhi.point.application.vo.*;
import org.apache.ibatis.annotations.Param;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.baomidou.mybatisplus.plugins.Page;

/**
 * <p>
 * 学员积分 Mapper 接口
 * </p>
 *
 * @author bob123
 * @since 2018-04-20
 */
public interface PointUserMapper extends BaseMapper<PointUser> {

    Integer queryPiont(@Param("userId") Long userId, @Param("companyId") Long companyId, @Param("siteId") Long siteId);

    List<PointUserListVO> userRankList(Page<PointUserListVO> page, @Param("vo") PointUserParamVO vo);

    List<PointUserListVO> userRankList(@Param("vo") PointUserParamVO vo);

    Integer acquirePoint(@Param("accountId") Long accountId, @Param("learnSourceId") Long learnSourceId, @Param("createTime") String createTime);

    Timestamp getStartDate();

    List<PointUserListVO> getNewUserRankList(@Param("vo") PointUserParamVO vo);

    Integer getNewUserRankCount(@Param("vo") PointUserParamVO vo);

    List<TotalPointVO> totalPoint(@Param("siteIds") List<Long> siteIds,
                                  @Param("startDate") String startDate, @Param("endDate") String endDate);

    List<PointUserPageListVO> list(@Param("page") Page<PointUserPageListVO> page, @Param("name") String name);

    int updateUserPointExchange(PointUserExchangeVO pointUserExchangeVO);
}
