package com.yizhi.application.redis;

import org.redisson.Redisson;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;

public class RedissonManager {

	private static final String RAtomicName = "genId_";

	private static Config config = new Config();
	private static RedissonClient redisson = null;

	public static void init(String key, String value) {
		try {
//			config.useClusterServers() // 这是用的集群server
//					.setScanInterval(2000) // 设置集群状态扫描时间
//					.setMasterConnectionPoolSize(10000) // 设置连接数
//					.setSlaveConnectionPoolSize(10000).addNodeAddress("redis://10.10.12.97:6379")
//					.addNodeAddress("redis://10.10.12.97:6389").addNodeAddress("redis://10.10.12.97:6399");
			if (key == null || "".equals(key)) {
				key = RAtomicName;
			}
			config.useSingleServer().setAddress("redis://10.10.12.97:6379");
			redisson = Redisson.create(config);
//			redisson = (Redisson) Redisson.create();
//			config.useClusterServers()
//			    .setScanInterval(2000) // 集群状态扫描间隔时间，单位是毫秒
//			    //可以用"rediss://"来启用SSL连接
//			    .addNodeAddress("redis://10.10.12.97:6389").addNodeAddress("redis://10.10.12.97:6395")
//			    .addNodeAddress("redis://10.10.12.97:6396").addNodeAddress("redis://10.10.12.97:6397")
//			    .addNodeAddress("redis://10.10.12.97:6398").addNodeAddress("redis://10.10.12.97:6399");
			
//			redisson = Redisson.create(config);
			// 清空自增的ID数字
			RAtomicLong atomicLong = redisson.getAtomicLong(key);
			long pValue = 1;
			if (value != null && !"".equals(value)) {
				pValue = Long.parseLong(value);
			}
			atomicLong.set(pValue);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public static RedissonClient getRedisson() {
		return redisson;
	}

	/** 获取redis中的原子ID */
	public static Long nextID() {
		RAtomicLong atomicLong = getRedisson().getAtomicLong(RAtomicName);
		// 原子性的获取下一个ID，递增1
		atomicLong.incrementAndGet();
		return atomicLong.get();
	}
}