package com.yizhi.application.controller;


import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.yizhi.application.domain.PointDetails;
import com.yizhi.application.service.PointDetailsService;
import com.yizhi.point.application.vo.PointDetailVO;
import com.yizhi.point.application.vo.PointImportVO;
import com.yizhi.point.application.vo.domain.PointDetailsVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import io.swagger.annotations.Api;

/**
 * <p>
 * 积分明细 前端控制器
 * </p>
 *
 * @author bob123
 * @since 2018-04-20
 */
@Api(tags = "我的积分  学员端", description = "我的积分  学员端")
@RestController
@RequestMapping("/api/point/detail")
public class PointDetailsController {

    private static final Logger LOG = LoggerFactory.getLogger(PointDetailsController.class);

    @Autowired
    PointDetailsService pointDetailsService;

    @GetMapping("/pointList")
    public Map<String, Object> pointList(@RequestParam("year") String year,
                                         @RequestParam(value = "type", required = false) String type,
                                         @RequestParam("accountId") Long accountId,
                                         @RequestParam("pageNo") Integer pageNo, @RequestParam("pageSize") Integer pageSize, @RequestParam("companyId") Long companyId,
                                         @RequestParam("siteId") Long siteId, @RequestParam("orgId") Long orgId) {
        return pointDetailsService.pointList(year, type, accountId, pageNo, pageSize, companyId, siteId, orgId);
    }

    /**
     * 小程序我的积分 首页请求接口
     * @param accountId
     * @param siteId
     * @return
     */
    @GetMapping("/getPointDetail")
    public PointDetailVO getPointDetail(@RequestParam("accountId") Long accountId,
                                        @RequestParam("siteId") Long siteId) {
        return pointDetailsService.getPointDetail( accountId,siteId);
    }

    @GetMapping("/countList")
    public Integer queryPiont(@RequestParam(name = "userId", required = false) Long userId, @RequestParam(name = "companyId", required = false) Long companyId,
                              @RequestParam("siteId") Long siteId, @RequestParam(name = "orgId", required = false) Long orgId) {
        return pointDetailsService.queryPiont(userId, companyId, siteId, orgId);
    }

    @PostMapping("/pointImport")
    boolean insertExternalPoint(@RequestBody List<PointImportVO> importVOList,
                                @RequestParam("companyId") Long companyId,
                                @RequestParam("siteId") Long siteId,
                                @RequestParam("orgId") Long orgId,
                                @RequestParam("accountId") Long accountId,
                                @RequestParam("accountName") String accountName) {
        return pointDetailsService.pointImport(importVOList, companyId, siteId, orgId, accountId, accountName);
    }

    @GetMapping("/statisticsPoint")
    List<PointDetailsVo> statisticsPoint() {

        List<PointDetails> pointDetails = pointDetailsService.statisticsPoint();
        List<PointDetailsVo> list = new ArrayList<>();
        for (PointDetails s:pointDetails
        ) {
            PointDetailsVo pointLevelVo =new PointDetailsVo();
            BeanUtils.copyProperties(s,pointLevelVo);
            list.add(pointLevelVo);
        }
        return list;
    }

    @GetMapping("/getPointByCondition")
    public Integer getPointByCondition(@RequestParam("accountId") Long accountId,
                                       @RequestParam("siteId") Long siteId,
                                       @RequestParam("bizIds") List<Long> bizIds) {
        return pointDetailsService.getPointByCondition(accountId, siteId, bizIds);
    }

    /**
     * 统计积分明细
     */
    @GetMapping("/sync/list")
    public List<PointDetailsVo> syncPointDetails(@RequestParam(name = "startDate",required = false) String startDate,
                                                 @RequestParam(name = "endDate",required = false) String endDate ,
                                                 @RequestParam(name = "companyId",required = false) Long companyId ,
                                                 @RequestParam(name = "siteId",required = false) Long siteId
    ){
        DateTime yesterday = DateUtil.yesterday();
        Date startTime = DateUtil.beginOfDay(yesterday);
        Date endTime = DateUtil.endOfDay(yesterday);
        if (!StringUtils.isEmpty(startDate)){
            startTime = DateUtil.parse(startDate, "yyyy-MM-dd HH:mm:ss");
        }
        if (!StringUtils.isEmpty(endDate)){
            endTime = DateUtil.parse(endDate, "yyyy-MM-dd HH:mm:ss");
        }
        return pointDetailsService.syncPointDetails(startTime,endTime,companyId,siteId);
    }

}

