package com.yizhi.point.application.feign;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.point.application.vo.*;
import com.yizhi.point.application.vo.domain.PointDetailsVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.sql.Timestamp;
import java.util.List;
import java.util.Map;

/**
 * 轮播
 *
 * @author HUIHUI.DUAN
 * @date 2018/3/28 10:44
 */
@FeignClient(name = "point", contextId = "PointUserFeignClients")
public interface PointUserFeignClients {

    @GetMapping("/manage/point/user/countList")
    Integer queryPiont(@RequestParam("userId") Long userId);

    @GetMapping("/manage/point/user/rank/list")
    Page<PointUserListVO> userRankList(@RequestBody PointUserParamVO vo);

    @GetMapping("/manage/point/user/new/rank/list")
    Page<PointUserListVO> newUserRankList(@RequestBody PointUserParamVO vo);

    @GetMapping("/manage/point/user/rank/list/export")
    List<PointUserListVO> userRankListExport(@RequestBody PointUserParamVO vo);

    @GetMapping("/manage/point/user/rank/list/startDate")
    Timestamp getStartDate();

    @GetMapping("/manage/point/user/point/acquire")
    public Integer acquirePoint(@RequestParam(name = "accountId", required = true) Long accountId,
                                @RequestParam(name = "learnSourceId", required = true) Long learnSourceId,
                                @RequestParam(name = "createTime", required = true) String createTime);

    @GetMapping("/manage/point/user/point/isHasPoint")
    public boolean isHasPoint(@RequestParam("bizId") Long bizId, @RequestParam("accountId") Long accountId);

    /**
     * 报表获取业务积分记录,可获取所有,可根据业务id,accountId
     *
     * @param bizId
     * @param accountId
     * @param companyId
     * @param siteId
     * @param isRealTime
     * @return
     */
    @GetMapping("/manage/point/user/getReportPoints")
    public List<PointDetailsVo> getReportPoints(@RequestParam(value = "bizId", required = false) Long bizId, @RequestParam(value = "accountId", required = false) Long accountId,
                                                @RequestParam(value = "companyId", required = false) Long companyId, @RequestParam(value = "siteId", required = false) Long siteId,
                                                @RequestParam(value = "isRealTime", required = true) boolean isRealTime);

    /**
     * 报表获取业务积分记录,可获取所有,可根据业务id,accountId
     *
     * @param bizId
     * @param accountId
     * @param isRealTime
     * @return
     */
    @GetMapping("/manage/point/user/getCourseReportPoints")
    public List<PointDetailsVo> getCourseReportPoints(@RequestParam(value = "bizId", required = false) Long bizId, @RequestParam(value = "accountId", required = false) Long accountId,
                                                      @RequestParam(value = "isRealTime", required = true) boolean isRealTime);


    /**
     * 周期内用户获取的总积分
     * @param accountId
     * @param siteIds
     * @param startDate
     * @param endDate
     * @return
     */
    @GetMapping("/manage/point/user/totalPoint")
    public Map<Long, Long> totalPoint( @RequestParam("siteIds") List<Long> siteIds,
			@RequestParam("startDate") String startDate, @RequestParam("endDate") String endDate);

    @GetMapping("/manage/point/user/list")
    public Page<PointUserPageListVO> list(@RequestBody PointSearchParamVO searchParamVO);

    @GetMapping("/manage/point/user/exchange")
    public int exchange(@RequestBody PointUserExchangeVO pointUserExchangeVO);
}
